<?php

namespace App\Controller;

use App\Controller\AppController;
use cake\ORM\TableRegistry;
use Cake\I18n\Time;
use Cake\Event\EventInterface;
use Cake\Core\Configure;
use Cake\Log\Log;
use Laminas\Diactoros\UploadedFile;

/**
 * Items Controller
 *
 * @property \App\Model\Table\ItemsTable $Items and AutoSparePartsTable $AutoSpareParts
 */
class FileUploadsController extends AppController
{
    public function initialize(): void
    {
        parent::initialize();
        // Load the Files model for use in this controller
        $this->files = $this->fetchTable('Files');
    }

    public function beforeRender(EventInterface $event)
    {
        parent::beforeRender($event);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->getParam('action');
        return true;
    }

    public function index($slug = null)
    {
        $sectionName = "Files Uploads";
        $pageTitle = 'All uploaded Files';


        $allUploadedFiles = $this->files->findAllFilesUploads();
        $listings = $this->paginate($allUploadedFiles);

        $this->set(compact('pageTitle', 'listings', 'sectionName'));
    }

    public function add()
    {
        $action = $this->request->getParam('action');

        $sectionName = "Files Uploads";

        $pageTitle = 'Add File';
        // Initialize a new Files entity
        $fileupload = $this->files->newEmptyEntity();

        if ($this->request->is(['post'])) {
            $file_field = 'file1';
            $data = $this->request->getData();
            $file = $this->request->getData($file_field);
            $data['title'] = $data['title'];
            $data['description'] = $data['description'];

            if (isset($file)) {
                $fileOK = $this->uploadFiles(Configure::read('IMAGE_PREPATH'), $file, null, null, false);

                if (!empty($fileOK['urls'])) {
                    $data['file_path'] = substr(
                        $fileOK['file_path'][0],
                        Configure::read('IMAGE_PRELENGTH'),
                        strlen($fileOK['file_path'][0])
                    );
                    $data['file_name'] = $file->getClientFilename();
                    $data['file_type'] = $file->getClientMediaType();
                    $data['file_size'] = $file->getSize();
                }
            }

            // Patch the entity with new data
            $fileupload = $this->files->patchEntity($fileupload, $data);

            // Attempt to save the entity
            try {
                if ($this->files->save($fileupload)) {
                    $this->Flash->success(__('Files added successfully.'));
                    return $this->redirect(['action' => 'index', 'pending']);
                } else {
                    // Log the error
                    Log::error('Failed to save fileupload entity', ['errors' => $fileupload->getErrors()]);
                    $this->Flash->error(__('The file could not be saved. Try again.'));
                }
            } catch (\Exception $e) {
                // Log the exception
                Log::error('Exception during file save', ['exception' => $e]);
                $this->Flash->error(__('An error occurred while saving the file. Please try again.'));
            }
        }

        $this->set(compact('pageTitle', 'fileupload', 'sectionName', 'action'));
    }

    public function edit($id)
    {
        $action = $this->request->getParam('action');

        $sectionName = "Files Uploads";
        $fileupload = $this->files->get($id);
        $pageTitle = 'Edit File';

        if ($this->request->is(['post', 'put', 'patch'])) {
            $file_field = 'file1';
            $valid = true;
            $data = $this->request->getData();
            $file = $this->request->getData($file_field);

            if (isset($data[$file_field])) {
                // Log the file upload attempt
                Log::debug('File upload attempt', ['file_field' => $file_field, 'file' => $file]);
                $fileOK = $this->uploadFiles(Configure::read('IMAGE_PREPATH'), $file, null, null, false);

                if (!empty($fileOK['urls'])) {
                    $data['file_path'] = substr(
                        $fileOK['file_path'][0],
                        Configure::read('IMAGE_PRELENGTH'),
                        strlen($fileOK['file_path'][0])
                    );
                    $data['file_name'] = $file->getClientFilename();
                    $data['file_type'] = $file->getClientMediaType();
                    $data['file_size'] = $file->getSize();
                }
            }

            $data['status'] = 2;

            $fileupload = $this->files->patchEntity($fileupload, $data);

            if ($this->files->save($fileupload)) {
                $this->Flash->success(__('Files updated successfully.'));
                return $this->redirect(['action' => 'editedListings']);
            } else {
                $this->Flash->error(__('The file could not be updated. Try again'));
            }
        }

        $this->set(compact('pageTitle', 'fileupload', 'sectionName', 'action'));
    }

    public function enable($id = null)
    {
        $result = $this->files->enable($id);

        if ($result) {
            $this->Flash->success(__('Content has been DISABLED successfully.'));
        } else {
            throw new NotFoundException(__('Content not found or already disabled.'));
        }

        return $this->redirect($this->referer());
    }

    public function disable($id = null)
    {
        $result = $this->files->disable($id);

        if ($result) {
            $this->Flash->success(__('Content has been DISABLED successfully.'));
        } else {
            throw new NotFoundException(__('Content not found or already disabled.'));
        }

        return $this->redirect($this->referer());
    }

    public function allListings($id = null)
    {
        $sectionName = "Files Uploads";
        $pageTitle = 'All Uploaded Files';

        $allUploadedFiles = $this->files->findAllFilesUploads();
        $listings = $this->paginate($allUploadedFiles);

        $this->set(compact('pageTitle', 'listings', 'sectionName'));
    }

    public function pendingListings($id = null)
    {
        $sectionName = "Files Uploads";
        $pageTitle = 'Pending Uploaded Files';

        $allUploadedFiles = $this->files->pendingListings();
        $listings = $this->paginate($allUploadedFiles);

        $this->set(compact('pageTitle', 'listings', 'sectionName'));
    }

    public function enableListings($id = null)
    {
        $sectionName = "Files Uploads";
        $pageTitle = 'Enabled Uploaded Files';

        $allUploadedFiles = $this->files->enableListings();
        $listings = $this->paginate($allUploadedFiles);

        $this->set(compact('pageTitle', 'listings', 'sectionName'));
    }

    public function disableListings($id = null)
    {
        $sectionName = "Files Uploads";
        $pageTitle = 'Disabled Uploaded Files';

        $allUploadedFiles = $this->files->disableListings();
        $listings = $this->paginate($allUploadedFiles);

        $this->set(compact('pageTitle', 'listings', 'sectionName'));
    }

    public function editedListings($id = null)
    {
        $sectionName = "Files Uploads";
        $pageTitle = 'Edited Uploaded Files';

        $allUploadedFiles = $this->files->editedListings();
        $listings = $this->paginate($allUploadedFiles);

        $this->set(compact('pageTitle', 'listings', 'sectionName'));
    }

}