<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Album Entity
 *
 * @property int $id
 * @property string|null $name
 * @property int $status
 * @property string|null $description
 * @property int $show_on_home
 * @property \Cake\I18n\DateTime $date_created
 * @property \Cake\I18n\DateTime|null $date_modified
 *
 * @property \App\Model\Entity\Gallery[] $galleries
 */
class Album extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'name' => true,
        'status' => true,
        'description' => true,
        'show_on_home' => true,
        'date_created' => true,
        'date_modified' => true,
        'galleries' => true,
    ];
}
