<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * AppSetting Entity
 *
 * @property int $id
 * @property string|null $setting_name
 * @property string|null $setting_type
 * @property string|null $setting_value
 * @property \Cake\I18n\DateTime $date_created
 * @property int|null $date_modified
 */
class AppSetting extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'setting_name' => true,
        'setting_type' => true,
        'setting_value' => true,
        'date_created' => true,
        'date_modified' => true,
    ];
}
