<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Gallery Entity
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $image_path
 * @property int $status
 * @property int|null $album_id
 * @property \Cake\I18n\DateTime $date_created
 * @property \Cake\I18n\DateTime $date_modified
 *
 * @property \App\Model\Entity\Album $album
 */
class Gallery extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'name' => true,
        'image_path' => true,
        'status' => true,
        'album_id' => true,
        'date_created' => true,
        'date_modified' => true,
        'album' => true,
    ];
}
