<p align="center">
	<?php echo $this->Paginator->counter(array('format' => __('Page {{page}} of {{pages}}, showing {{current}} records out of {{count}} total, starting on record {{start}}, ending on {{end}}'))); ?>
</p>
<hr class="separate-title"/>
	
<div class="row">
	<div class="col-sm-12">
		<div style="float: left">
			<?php echo '<div class="search-text">Search Featured:&nbsp;&nbsp</div>'; ?>
		</div>
		<div style="float: left;margin-right: 20px">
			<?php
				echo $this->Form->create(null);
				echo $this->Form->input('search',array('id' => 'searchbox','class' => 'form-control search-box', 'label' => false));
			?>
		</div>
		<div style="float: left">
			<?php
				echo $this->Form->button('Search',['type' => 'submit', 'class'=>'btn btn-primary']);
				echo $this->Form->end();
			 ?>
		</div>
	</div>
</div>

<div class="row">
	<div class="col-sm-12">
		<div class="table-responsive">
			<table class="table table-striped">
				<thead>
					<th>Title</th>
					<th>Publish Date</th>
					<th>Email</th>
					<th>Phone</th>
					<th>Start Date</th>
					<th>End Date</th>
					<th>Viewed</th>
					<th>Actions</th>
				</thead>
				<tbody>
					<?php
						$i = 0;
						foreach ($listings as $listing):  
					?>
					<tr>
										
						<td><?php echo $listing->title; ?></td>
						<td><?php echo date('d-m-Y', strtotime($listing->publish_date)); ?></td>
						<td><?php echo $listing->contact_email; ?></td>
						<td><?php echo $listing->contact_tel; ?></td>
						<td><?php echo $listing->featured_start_date; ?></td>
						<td><?php echo $listing->featured_end_date; ?></td>
						<td><?php echo $listing->viewed; ?></td>
							
						<td class="actions">
							<?php 
								if(isset($category)){
									echo $this->Html->link(__('Edit '), ['controller' => $section, 'action' => $category, 'edit', $listing->id, preg_replace('#[ -]+#', '-', $listing->title)]); 
									echo ' | ';
								}
								
								if($listing->featured == 9){ 
									echo $this->Html->link(__('Enable '), ['action' => 'enableFeatured', $listing->id]); 
									echo " | ";
									echo $this->Html->link(__('Disable '), ['action' => 'disableFeatured', $listing->id]); 
								} 
								else if($listing->featured == 1){ 
									echo $this->Html->link(__('Disable '), ['action' => 'disableFeatured', $listing->id]); 
								}
								else if($listing->featured == 99){ 
									echo $this->Html->link(__('Enable '), ['action' => 'enableFeatured', $listing->id]);
									
								} 

								
							?>
						</td>
					</tr>
					<?php endforeach; ?>		
				</tbody>
			</table>
		</div>	
	</div>
</div>

<div class="row">
	<div class="col-sm-12">
		<div class="paginator" style="text-align: center;">
			<ul class="pagination">
				<?= $this->Paginator->prev('< ' . __('prev')) ?>
				<?= $this->Paginator->numbers(['first' => 3, 'last' => 3, 'modulus' => 4]) ?>
				<?= $this->Paginator->next(__('next') . ' >') ?>
			</ul>
			<p><?= $this->Paginator->counter() ?></p>
		</div>
	</div>
</div>