

<p align="center">
	<?php echo $this->Paginator->counter(array('format' => __('Page {{page}} of {{pages}}, showing {{current}} records out of {{count}} total, starting on record {{start}}, ending on {{end}}'))); ?>
</p>
<hr class="separate-title"/>
	
<div class="row">
	<div class="col-sm-12">
		<div style="float: left">
			<?php echo '<div class="search-text">Search Listing:&nbsp;&nbsp</div>'; ?>
		</div>
		<div style="float: left;margin-right: 20px">
			<?php
			 
				echo $this->Form->create(null, ['type'=>'get', 'url'=>['action'=>'listings', isset($this->request->params['section']) ? $this->request->params['section'] : '', isset($this->request->params['category'])?$this->request->params['category'] : '']]);
				echo $this->Form->input('search',array('id' => 'search','class' => 'form-control search-box', 'label' => false));
			?>
		</div>
		<div style="float: left">
			<?php
				echo $this->Form->button('Search',['type' => 'submit', 'class'=>'btn btn-primary']);
				echo $this->Form->end();
			 ?>
		</div>
	</div>
</div>

<div class="row">
	<div class="col-sm-12">
		<div class="table-responsive">
			<table class="table table-striped">
				<thead>
					<th>Title</th>
					<th>User ID</th>
					<th>Publish Date</th>
					<th>Email</th>
					<th>Phone</th>
					<th>Viewed</th>
					<th>Actions</th>
				</thead>
				<tbody>
					<?php
						$i = 0;
						foreach ($listings as $listing):  
					?>
					<tr>
										
						<td><?php echo $listing->title; ?></td>
						<td><?php echo $listing->user_id; ?></td>
						<td><?php echo date('d-m-Y', strtotime($listing->publish_date)); ?></td>
						<td><?php echo $listing->contact_email; ?></td>
						<td><?php echo $listing->contact_tel; ?></td>
						<td><?php echo $listing->viewed; ?></td>
							
						<td class="actions">
							<?php

								if(isset($category)){
									echo $this->Html->link(__('Edit '), ['controller' => $section, 'action' => 'editListing',$category, $listing->id, preg_replace('#[ -]+#', '-', $listing->title)]); 
									echo ' | ';
								}
								// debug($listing);
								//exit;
								if(isset($showTemporal)){
									if($listing->temporal == 1){
										echo $this->Html->link(__('Untemporary'), ['action' => 'unsetTemporal', $listing->id]) . " | ";
									}
									else{ 
										echo $this->Html->link(__('Temporary'), ['action' => 'setTemporal', $listing->id]) . " | "; 
									}
								}

								if($listing->status == 0 || $listing->status == 2){ 
									echo $this->Html->link(__('Enable '), ['action' => 'enablelisting', $listing->id]); 
									echo " | ";
									echo $this->Html->link(__('Disable '), ['action' => 'disablelisting', $listing->id]); 
								} 
								else if($listing->status == 1){ 
									echo $this->Html->link(__('Disable '), ['action' => 'disablelisting', $listing->id]); 
								}
								else if($listing->status == 2){ 
									echo $this->Html->link(__('Enable '), ['action' => 'enablelisting', $listing->id]); 
									echo " | ";
									echo $this->Html->link(__('Disable '), ['action' => 'disablelisting', $listing->id]); 
								}
								else if($listing->status == 99){ 
									echo $this->Html->link(__('Enable '), ['action' => 'enablelisting', $listing->id]); 
								} 
							?>
						</td>
					</tr>
					<?php endforeach; ?>		
				</tbody>
			</table>
		</div>	
	</div>
</div>

<div class="row">
	<div class="col-sm-12">
		<div class="paginator" style="text-align: center;">
			<ul class="pagination">
				<?= $this->Paginator->prev('< ' . __('prev')) ?>
				<?= $this->Paginator->numbers(['first' => 3, 'last' => 3, 'modulus' => 4]) ?>
				<?= $this->Paginator->next(__('next') . ' >') ?>
			</ul>
			<p><?= $this->Paginator->counter() ?></p>
		</div>
	</div>
</div>

		