<div class="bg-light shadow-sm py-3 mb-3 rounded-3">

    <div class="row justify-content-center ">
        <div class="col-12 col-lg-11">

            <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap">
                <?= $this->Paginator->limitControl(
                    [10 => 10, 25 => 25, 50 => 50, 100 => 100],
                    null,
                    [
                        'label' => 'Items per page:',
                        'class' => 'form-select w-auto d-inline-block ms-2'
                    ]
                ); ?>

                <?= $this->Form->create(null, ['type' => 'get', 'class' => 'd-flex justify-content-end mt-2 mt-md-0']) ?>
                <?= $this->Form->control('search', [
                    'type' => 'text',
                    'label' => false,
                    'placeholder' => 'Search',
                    'id' => 'customSearch',
                    'value' => $searchTerm ?? '',
                    'class' => 'form-control me-2 w-auto'
                ]) ?>
                <?= $this->Form->button('Search', ['type' => 'submit', 'id' => 'searchBtn', 'class' => 'btn btn-primary']) ?>
                <?= $this->Form->end() ?>
            </div>

            <table class="table table-stripeds table-hover">

                <thead>
                    <tr>
                        <th>File Name</th>
                        <th>Link</th>
                        <th>Title</th>
                        <th>Description </th>
                        <th>Actions</th>
                    </tr>
                </thead>

                <tbody class="table-group-divider">
                    <?php foreach ($listings as $listing): ?>
                        <?php $file_path = Cake\Core\Configure::read('IMAGE_PREPATH') . $listing->file_path; ?>
                        <tr>
                            <td data-label="Banner">
                                <?= '<a target="_blank" href="' . $this->Url->image($file_path) . '">' . $listing->file_name . '</a>' ?>
                            </td>

                            <td data-label="File Name"><?= $listing->file_path ?></td>

                            <td data-label="Link">
                                <?= $listing->description ?>
                            </td>

                            <td data-label="Link">
                                <?= $listing->description ?>
                            </td>

                            <td data-label="Actions">
                                <div class="d-flex flex-wrap gap-1">
                                    <!-- Edit -->
                                    <?= $this->Html->link(
                                        '<i class="bi bi-pencil-square"></i>',
                                        ['action' => 'edit',$listing->id],
                                        ['class' => 'btn btn-sm btn-outline-info', 'escape' => false, 'title' => 'Edit', 'data-bs-toggle' => 'tooltip']
                                    ) ?>

                                    <!-- Enable / Disable -->
                                    <?php if ($listing->status == 1): ?>
                                        <?= $this->Html->link(
                                            '<i class="bi bi-x-circle"></i>',
                                            ['action' => 'disable',$listing->id],
                                            ['class' => 'btn btn-sm btn-outline-danger', 'escape' => false, 'title' => 'Disable', 'data-bs-toggle' => 'tooltip']
                                        ) ?>
                                    <?php else: ?>

                                        <?= $this->Html->link(
                                            '<i class="bi bi-check-circle"></i>',
                                            ['action' => 'enable', $listing->id],
                                            ['class' => 'btn btn-sm btn-outline-success', 'escape' => false, 'title' => 'Enable', 'data-bs-toggle' => 'tooltip']
                                        ) ?>
                                    <?php endif ?>

                                </div>
                            </td>

                        </tr>
                    <?php endforeach; ?>
                </tbody>

            </table>

            <?php echo $this->element('pagination'); ?>

        </div>
    </div>
</div>