<div class="bg-light shadow-sm py-3 mb-3 rounded-3">

  <div class="row justify-content-center ">
    <div class="col-12 col-lg-11">

      <table id="submenu" class="table table-striped border border-1 mt-2">
        <thead>
          <tr>
            <th>Name</th>
            <th>Descriptions</th>
            <th>Content</th>
            <th>Image</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($listings as $listing):
            $img = Cake\Core\Configure::read('IMAGE_PREPATH') . $listing->image_path;
            $contentBlocks = json_decode($listing->content, true);
            ?>
            <tr>
              <td><?= $listing->name; ?></td>
              <td><?= $listing->description; ?></td>
              <td>
                <?= $this->Text->truncate(strip_tags($contentBlocks[0]['content'] ?? ''), 90, ['ellipsis' => '...', 'exact' => false]) ?>
              <td>
                <div class="">
                  <?= isset($listing->image_path) && trim($listing->image_path) != '' ? '<a href="' . $this->Url->image($img) . '">' . $this->Html->image($img, ['height' => '50px']) . '</a>' : '' ?>
                </div>
              </td>
              <td>
                <div class="d-flex flex-wrap gap-1">
                  <!-- Edit -->
                  <?= $this->Html->link(
                    '<i class="bi bi-pencil-square"></i>',
                    ['controller' => $slug, 'action' => 'edit' . $actiontitle, $listing->pmid, $listing->id],
                    ['class' => 'btn btn-sm btn-outline-info', 'escape' => false, 'title' => 'Edit', 'data-bs-toggle' => 'tooltip']
                  ) ?>

                  <!-- Enable / Disable -->
                  <?php if ($listing->status == 1): ?>
                    <?= $this->Html->link(
                      '<i class="bi bi-x-circle"></i>',
                      ['controller' => $slug, 'action' => 'disableMenu', $listing->id],
                      ['class' => 'btn btn-sm btn-outline-danger', 'escape' => false, 'title' => 'Disable', 'data-bs-toggle' => 'tooltip']
                    ) ?>

                  <?php else: ?>
                    <?= $this->Html->link(
                      '<i class="bi bi-check-circle"></i>',
                      ['controller' => $slug, 'action' => 'enableMenu', $listing->id],
                      ['class' => 'btn btn-sm btn-outline-success', 'escape' => false, 'title' => 'Enable', 'data-bs-toggle' => 'tooltip']
                    ) ?>
                  <?php endif; ?>

                  <!-- Home -->
                  <?php if ($listing->show_on_home == 1): ?>
                    <?= $this->Html->link(
                      '<i class="bi bi-house-x"></i>',
                      ['controller' => $slug, 'action' => 'removeMenuFromHome', $listing->id],
                      ['class' => 'btn btn-sm btn-outline-warning', 'escape' => false, 'title' => 'Remove from Home', 'data-bs-toggle' => 'tooltip']
                    ) ?>
                  <?php else: ?>
                    <?= $this->Html->link(
                      '<i class="bi bi-house-door"></i>',
                      ['controller' => $slug, 'action' => 'showMenuOnHome', $listing->id],
                      ['class' => 'btn btn-sm btn-outline-primary', 'escape' => false, 'title' => 'Show on Home', 'data-bs-toggle' => 'tooltip']
                    ) ?>
                  <?php endif; ?>

                  <!-- Footer -->
                  <?php if ($listing->show_on_footer == 1): ?>
                    <?= $this->Html->link(
                      '<i class="bi bi-layout-sidebar-inset-reverse"></i>',
                      ['controller' => $slug, 'action' => 'removeMenuFromFooter', $listing->id],
                      ['class' => 'btn btn-sm btn-outline-dark', 'escape' => false, 'title' => 'Remove from Footer', 'data-bs-toggle' => 'tooltip']
                    ) ?>
                  <?php else: ?>
                    <?= $this->Html->link(
                      '<i class="bi bi-layout-sidebar-inset"></i>',
                      ['controller' => $slug, 'action' => 'showMenuOnFooter', $listing->id],
                      ['class' => 'btn btn-sm btn-outline-danger', 'escape' => false, 'title' => 'Show on Footer', 'data-bs-toggle' => 'tooltip']
                    ) ?>
                  <?php endif; ?>
                </div>
              </td>
            </tr>
          <?php endforeach ?>
        </tbody>
      </table>

    </div>
  </div>
</div>