<style>
    .pagination-sm .page-link {
        padding: 0.25rem 0.5rem;
        font-size: 0.875rem;
        line-height: 1.5;
    }
    .page-item.active .page-link {
        background-color: #0D6EFD;
        border-color: #2e60f3c8;
    }
    .page-link {
        color: #4e73df;
        border: 1px solid #d1d3e2;
        margin-left: -1px;
    }
    .page-link:hover {
        color: #224abe;
        background-color: #eaecf4;
        border-color: #d1d3e2;
    }
    .page-item.disabled .page-link {
        color: #b7b9cc;
        pointer-events: none;
        cursor: auto;
        background-color: #fff;
        border-color: #d1d3e2;
    }
    .dataTables-info {
        color: #6c757d;
        font-size: 0.875rem;
    }
</style>

<!-- Enhanced Pagination Controls with DataTable-like styling -->
<div class="row mt-4 align-items-center">
    <div class="col-md-6">
        <div class="dataTables-info">
            <?= $this->Paginator->counter(
                __('Showing <span class="font-weight-bold">{{start}}</span> to <span class="font-weight-bold">{{end}}</span> of <span class="font-weight-bold">{{count}}</span> entries')
            ) ?>
        </div>
    </div>
    <div class="col-md-6">
        <nav aria-label="Page navigation" class="d-flex justify-content-end">
            <ul class="pagination pagination-sm mb-0">
                <!-- <.?= $this->Paginator->first(
                    '« First',
                    [
                        'class' => 'page-item',
                        'escape' => false,
                        'templates' => ['firstActive' => '<li class="page-item"><a class="page-link" href="{{url}}">{{text}}</a></li>',
                                        'firstDisabled' => '<li class="page-item disabled"><a class="page-link" href="{{url}}">{{text}}</a></li>']
                    ]
                ) ?> -->
                
                <?= $this->Paginator->prev(
                    '‹ Prev',
                    [
                        'class' => 'page-item',
                        'escape' => false,
                        'templates' => ['prevActive' => '<li class="page-item"><a class="page-link" href="{{url}}">{{text}}</a></li>',
                                      'prevDisabled' => '<li class="page-item disabled"><a class="page-link" href="{{url}}">{{text}}</a></li>']
                    ]
                ) ?>

                <?= $this->Paginator->numbers([
                    'modulus' => 4,
                    'first' => 2,
                    'last' => 2,
                    'templates' => [
                        'number' => '<li class="page-item"><a class="page-link" href="{{url}}">{{text}}</a></li>',
                        'current' => '<li class="page-item active"><a class="page-link" href="#">{{text}}</a></li>'
                    ],
                    'url' => ['controller' => $slug, 'action' => $this->request->getParam('action')]
                ]) ?>

                <?= $this->Paginator->next(
                    'Next ›',
                    [
                        'class' => 'page-item',
                        'escape' => false,
                        'templates' => ['nextActive' => '<li class="page-item"><a class="page-link" href="{{url}}">{{text}}</a></li>',
                                      'nextDisabled' => '<li class="page-item disabled"><a class="page-link" href="{{url}}">{{text}}</a></li>']
                    ]
                ) ?>
                
                <!-- <.?= $this->Paginator->last(
                    'Last »',
                    [
                        'class' => 'page-item',
                        'escape' => false,
                        'templates' => ['lastActive' => '<li class="page-item"><a class="page-link" href="{{url}}">{{text}}</a></li>',
                                      'lastDisabled' => '<li class="page-item disabled"><a class="page-link" href="{{url}}">{{text}}</a></li>']
                    ]
                ) ?> -->
            </ul>
        </nav>
    </div>
</div>

