<?php
/**
 * Routes configuration.
 *
 * In this file, you set up routes to your controllers and their actions.
 * Routes are very important mechanism that allows you to freely connect
 * different URLs to chosen controllers and their actions (functions).
 *
 * It's loaded within the context of `Application::routes()` method which
 * receives a `RouteBuilder` instance `$routes` as method argument.
 *
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link          https://cakephp.org CakePHP(tm) Project
 * @license       https://opensource.org/licenses/mit-license.php MIT License
 */

use Cake\Routing\Route\DashedRoute;
use Cake\Routing\RouteBuilder;

/*
 * This file is loaded in the context of the `Application` class.
 * So you can use  `$this` to reference the application class instance
 * if required.
 */
return function (RouteBuilder $routes): void {
    /*
     * The default class to use for all routes
     *
     * The following route classes are supplied with CakePHP and are appropriate
     * to set as the default:
     *
     * - Route
     * - InflectedRoute
     * - DashedRoute
     *
     * If no call is made to `Router::defaultRouteClass()`, the class used is
     * `Route` (`Cake\Routing\Route\Route`)
     *
     * Note that `Route` does not do any inflections on URLs which will result in
     * inconsistently cased URLs when used with `{plugin}`, `{controller}` and
     * `{action}` markers.
     */
    $routes->setRouteClass(DashedRoute::class);

    $routes->scope('/', function (RouteBuilder $builder): void {
        /*
         * Here, we are connecting '/' (base path) to a controller called 'Pages',
         * its action called 'display', and we pass a param to select the view file
         * to use (in this case, templates/Pages/home.php)...
         */
        $builder->connect('/', ['controller' => 'Users', 'action' => 'login']);

        /*
         * ...and connect the rest of 'Pages' controller's URLs.
         */
        $builder->connect(
            '/users/logout',
            [
                'controller' => 'Users',
                'action' => 'logout'
            ]
        );

        $builder->connect(
            '/{section}/sub/{category}',
            [
                'controller' => 'SubMenu',
                'action' => 'index'
            ],
            [
                'pass' => ['section', 'category']
            ]
        );

        $builder->connect(
            '/gallery/albums',
            [
                'controller' => 'Albums',
                'action' => 'index'
            ]
        );

        $builder->connect(
            '/gallery/albums/add',
            [
                'controller' => 'Albums',
                'action' => 'add'
            ]
        );

        $builder->connect(
            '/gallery/albums/all',
            [
                'controller' => 'Albums',
                'action' => 'index'
            ]
        );

        $builder->connect(
            '/gallery/albums/edit/{id}',
            [
                'controller' => 'Albums',
                'action' => 'edit'
            ],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/gallery/albums/{action}/{id}',
            [
                'controller' => 'Albums',
                'action' => 'edit'
            ],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/about-us/sub/{section}/{action}/**',
            ['controller' => 'AboutUsMenu'],
            [
                'pass' => ['section']
            ]

        );


        $builder->connect(
            '/{section}/sub/{category}/{action}/**',
            ['controller' => 'SubMenu'],
            [
                'pass' => ['section', 'category']
            ]

        );

        $builder->connect(
            '/{section}/add-sub-menu/{id}',
            ['controller' => 'Menus', 'action' => 'addSubMenu'],
            [
                'pass' => ['section', 'id']
            ]

        );
        $builder->connect(
            '/{section}/edit-sub-menu/{id}',
            ['controller' => 'Menus', 'action' => 'editSubMenu'],
            [
                'pass' => ['section', 'id']
            ]

        );

        $builder->connect(
            '/{section}/pending-sub-menu/{id}',
            ['controller' => 'Menus', 'action' => 'pendingSubMenu'],
            [
                'pass' => ['section', 'id']
            ]

        );

        $builder->connect(
            '/{section}/enabled-sub-menu/{id}',
            ['controller' => 'Menus', 'action' => 'enabledSubMenu'],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/{section}/disabled-sub-menu/{id}',
            ['controller' => 'Menus', 'action' => 'disabledSubMenu'],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/{section}/edited-sub-menu/{id}',
            ['controller' => 'Menus', 'action' => 'editedSubMenu'],
            [
                'pass' => ['section', 'id']
            ]
        );


        $builder->connect(
            '/{section}/sub-menus/{id}',
            ['controller' => 'Menus', 'action' => 'subMenus'],
            [
                'pass' => ['section', 'id']
            ]

        );

        $builder->connect(
            '/{section}/add-sub-sub-menu/{id}',
            ['controller' => 'Menus', 'action' => 'addSubSubMenu'],
            [
                'pass' => ['section', 'id']
            ]

        );

        $builder->connect(
            '/{section}/sub-sub-menus/{id}',
            ['controller' => 'Menus', 'action' => 'subSubMenus'],
            [
                'pass' => ['section', 'id']
            ]

        );

        $builder->connect(
            '/{section}/edit-sub-sub-menu/{id}',
            ['controller' => 'Menus', 'action' => 'editSubSubMenu'],
            [
                'pass' => ['section', 'id']
            ]

        );

        $builder->connect(
            '/{section}/pending-sub-sub-menu/{id}',
            ['controller' => 'Menus', 'action' => 'pendingSubSubMenu'],
            [
                'pass' => ['section', 'id']
            ]

        );

        $builder->connect(
            '/{section}/enabled-sub-sub-menu/{id}',
            ['controller' => 'Menus', 'action' => 'enabledSubSubMenu'],
            [
                'pass' => ['section', 'id']
            ]

        );

        $builder->connect(
            '/{section}/disabled-sub-sub-menu/{id}',
            ['controller' => 'Menus', 'action' => 'disabledSubSubMenu'],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/{section}/edited-sub-sub-menu/{id}',
            ['controller' => 'Menus', 'action' => 'editedSubSubMenu'],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/{section}/disable-menu/{id}',
            ['controller' => 'Menus', 'action' => 'disableMenu'],
            [
                'pass' => ['section', 'id']
            ]

        );
        $builder->connect(
            '/{section}/enable-menu/{id}',
            ['controller' => 'Menus', 'action' => 'enableMenu'],
            [
                'pass' => ['section', 'id']
            ]

        );
        $builder->connect(
            '/{section}/update-sub-menu/{id}',
            ['controller' => 'Menus', 'action' => 'updateSubMenu'],
            [
                'pass' => ['id']
            ]
        );
        $builder->connect(
            '/{section}/remove-menu-from-home/{id}',
            ['controller' => 'Menus', 'action' => 'removeMenuFromHome'],
            [
                'pass' => ['id']
            ]
        );
        $builder->connect(
            '/{section}/show-menu-on-home/{id}',
            ['controller' => 'Menus', 'action' => 'showMenuOnHome'],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/{section}/show-menu-on-footer/{id}',
            ['controller' => 'Menus', 'action' => 'showMenuOnFooter'],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/{section}/remove-menu-from-footer/{id}',
            ['controller' => 'Menus', 'action' => 'removeMenuFooter'],
            [
                'pass' => ['id']
            ]
        );

        /*
         $builder->connect('/products/sub/product-categories', ['controller' => 'Categories', 'action' => 'viewAllCategories'],
        [
        'pass' => ['section']
        ]
        ); 
         $builder->connect('/products/sub/product-categories/{action}', ['controller' => 'Categories'],
        [
        'pass' => []
        ]
        ); 
         $builder->connect('/products/sub/product-categories/{action}/{id}', ['controller' => 'Categories'],
        [
        'pass' => ['id']
        ]
        ); 
         $builder->connect('/products/sub/product-categories/{action}/:pid/{id}', ['controller' => 'Categories'],
        [
        'pass' => ['pid','id']
        ]
        ); 
         $builder->connect('/products/sub/{section}', ['controller' => 'AboutUsMenu', 'action' => 'index'],
        [
        'pass' => ['section']
        ]
        );
        */

        /**
         * Set routes for standard controllers already defined for specific sections
         * from the matching the route
         * Basic contents supports
         * 1. Listing (All, Pending, Enable, Disable, Edited)
         * 2. Add new item
         * 3. Edit item
         * 4. Enable item
         * 5. Disable item
         */
        // Section: Home
        $builder->connect(
            '/home',
            [
                'controller' => 'Home',
            ]
        );

        /**
         * This route should have been taken care of from {section} menu above
         * but some home it doesnt execute the routes sequentially, it seems to have
         * priority levels with the construction before top down sequence.
         * So recreate the menu routes for each section with a controller created for it
         */
        $builder->connect(
            '/home/add-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'addSubMenu',
                'section' => 'home'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/home/edit-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'editSubMenu',
                'section' => 'home'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/home/edit-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'editSubSubMenu',
                'section' => 'home'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/home/sub-menus/{id}',
            [
                'controller' => 'Menus',
                'action' => 'subMenus',
                'section' => 'home'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/home/add-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'addSubSubMenu',
                'section' => 'home'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/home/sub-sub-menus/{id}',
            [
                'controller' => 'Menus',
                'action' => 'subSubMenus',
                'section' => 'home'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/home/disable-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'disableMenu',
                'section' => 'home'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/home/enable-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'enableMenu',
                'section' => 'home'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );
        $builder->connect(
            '/home/remove-menu-from-home/{id}',
            ['controller' => 'Menus', 'action' => 'removeMenuFromHome'],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/home/show-menu-on-home/{id}',
            ['controller' => 'Menus', 'action' => 'showMenuOnHome'],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/home/show-menu-on-footer/{id}',
            ['controller' => 'Menus', 'action' => 'showMenuOnFooter'],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/home/remove-menu-from-footer/{id}',
            ['controller' => 'Menus', 'action' => 'removeMenuFooter'],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/home/pending-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'pendingSubMenu',
                'section' => 'home'

            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/home/enabled-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'enabledSubMenu',
                'section' => 'home'

            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/home/disabled-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'disabledSubMenu',
                'section' => 'home'

            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/home/edited-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'editedSubMenu',
                'section' => 'home'

            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/home/pending-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'pendingSubSubMenu',
            ],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/home/enabled-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'enabledSubSubMenu',
            ],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/home/disabled-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'disabledSubSubMenu',
            ],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/home/edited-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'editedSubSubMenu',
            ],
            [
                'pass' => ['id']
            ]
        );
        /** Menu re rounting End here **/

        $builder->connect(
            '/home/{action}',
            [
                'controller' => 'Home',
            ]
        );

        $builder->connect(
            '/home/{action}/{id}',
            [
                'controller' => 'Home',
            ],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/home/{action}/{id}/{cid}',
            [
                'controller' => 'Home',
            ],
            [
                'pass' => ['id', 'cid']
            ]
        );

        $builder->connect(
            '/home/{action}/{id}/{cid}/{pcid}',
            [
                'controller' => 'Home',
            ],
            [
                'pass' => ['id', 'cid', 'pcid']
            ]
        );

        /**
         * Set routes for standard controllers already defined for specific sections
         * from the matching the route
         * Basic contents supports
         * 1. Listing (All, Pending, Enable, Disable, Edited)
         * 2. Add new item
         * 3. Edit item
         * 4. Enable item
         * 5. Disable item
         */
        // Section: AboutUs
        $builder->connect(
            '/about-us',
            [
                'controller' => 'AboutUs',
            ]
        );

        /**
         * This route should have been taken care of from {section} menu above
         * but some home it doesnt execute the routes sequentially, it seems to have
         * priority levels with the construction before top down sequence.
         * So recreate the menu routes for each section with a controller created for it
         */
        $builder->connect(
            '/about-us/add-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'addSubMenu',
                'section' => 'about-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/about-us/edit-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'editSubMenu',
                'section' => 'about-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/about-us/edit-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'editSubSubMenu',
                'section' => 'about-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/about-us/sub-menus/{id}',
            [
                'controller' => 'Menus',
                'action' => 'subMenus',
                'section' => 'about-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/about-us/add-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'addSubSubMenu',
                'section' => 'about-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/about-us/sub-sub-menus/{id}',
            [
                'controller' => 'Menus',
                'action' => 'subSubMenus',
                'section' => 'about-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/about-us/pending-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'pendingSubSubMenu',
                'section' => 'about-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/about-us//enabled-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'enabledSubSubMenu',
                'section' => 'about-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/about-us//disabled-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'disabledSubSubMenu',
                'section' => 'about-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/about-us//edited-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'editedSubSubMenu',
                'section' => 'about-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/about-us/disable-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'disableMenu',
                'section' => 'about-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/about-us/pending-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'pendingSubMenu',
                'section' => 'about-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/about-us/enabled-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'enabledSubMenu',
                'section' => 'about-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/about-us/disabled-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'disabledSubMenu',
                'section' => 'about-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/about-us/edited-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'editedSubMenu',
                'section' => 'about-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/about-us/enable-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'enableMenu',
                'section' => 'about-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );
        $builder->connect(
            '/about-us/remove-menu-from-home/{id}',
            ['controller' => 'Menus', 'action' => 'removeMenuFromHome'],
            [
                'pass' => ['id']
            ]
        );
        $builder->connect(
            '/about-us/show-menu-on-home/{id}',
            ['controller' => 'Menus', 'action' => 'showMenuOnHome'],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/about-us/remove-menu-from-footer/{id}',
            ['controller' => 'Menus', 'action' => 'removeMenuFooter'],
            [
                'pass' => ['id']
            ]
        );
        $builder->connect(
            '/about-us/show-menu-on-footer/{id}',
            ['controller' => 'Menus', 'action' => 'showMenuOnFooter'],
            [
                'pass' => ['id']
            ]
        );
        /** Menu re rounting End here **/

        $builder->connect(
            '/about-us/{action}',
            [
                'controller' => 'AboutUs',
            ]
        );

        $builder->connect(
            '/about-us/{action}/{id}',
            [
                'controller' => 'AboutUs',
            ],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/about-us/{action}/{id}/{cid}',
            [
                'controller' => 'AboutUs',
            ],
            [
                'pass' => ['id', 'cid']
            ]
        );

        $builder->connect(
            '/about-us/{action}/{id}/{cid}/{pcid}',
            [
                'controller' => 'AboutUs',
            ],
            [
                'pass' => ['id', 'cid', 'pcid']
            ]
        );
        $builder->connect(
            '/about-us/list-contents',
            [
                'controller' => 'Contents',
                'action' => 'listContents',
                'section' => 'about-us'
            ],
            [
                'pass' => ['section']
            ]
        );

        $builder->connect(
            '/about-us/order-content',
            [
                'controller' => 'Contents',
                'action' => 'orderContent',
                'section' => 'about-us'
            ],
            [
                'pass' => ['id']
            ]
        );
        $builder->connect(
            '/about-us/disable-order-value/{id}',
            [
                'controller' => 'Contents',
                'action' => 'disableOrderValue',
                'section' => 'about-us'
            ],
            [
                'pass' => ['id']
            ]
        );
        $builder->connect(
            '/about-us/enable-order-value/{id}',
            [
                'controller' => 'Contents',
                'action' => 'enableOrderValue',
                'section' => 'about-us'
            ],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/about-us/disabled-content-items',
            [
                'controller' => 'Contents',
                'action' => 'disabledContentItems',
                'section' => 'about-us'

            ]
        );

        // Section: Events

        $builder->connect(
            '/events',
            [
                'controller' => 'Events',
            ]
        );

        $builder->connect(
            '/events/add/{id}',
            [
                'controller' => 'Events',
                'action' => 'add'
            ],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/events/edit/{id}/{cid}/{pcid}',
            [
                'controller' => 'Events',
                'action' => 'edit'
            ],
            [
                'pass' => ['id', 'cid', 'pcid']
            ]
        );

        $builder->connect(
            '/events/remove/{id}',
            [
                'controller' => 'Events',
                'action' => 'remove'
            ],
            [
                'pass' => ['id']
            ]
        );




        /**
         * Set routes for standard controllers already defined for specific sections
         * from the matching the route
         * Basic contents supports
         * 1. Listing (All, Pending, Enable, Disable, Edited)
         * 2. Add new item
         * 3. Edit item
         * 4. Enable item
         * 5. Disable item
         */
        // Section: Services
        $builder->connect(
            '/services',
            [
                'controller' => 'Services',
            ]
        );

        /**
         * This route should have been taken care of from {section} menu above
         * but some home it doesnt execute the routes sequentially, it seems to have
         * priority levels with the construction before top down sequence.
         * So recreate the menu routes for each section with a controller created for it
         */
        $builder->connect(
            '/services/add-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'addSubMenu',
                'section' => 'services'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/services/pending-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'pendingSubMenu',
                'section' => 'services'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/services/enabled-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'enabledSubMenu',
                'section' => 'services'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/services/disabled-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'disabledSubMenu',
                'section' => 'services'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/services/edited-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'editedSubMenu',
                'section' => 'services'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/services/edit-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'editSubMenu',
                'section' => 'services'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/services/edit-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'editSubSubMenu',
                'section' => 'services'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/services/sub-menus/{id}',
            [
                'controller' => 'Menus',
                'action' => 'subMenus',
                'section' => 'services'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/services/add-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'addSubSubMenu',
                'section' => 'services'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/services/sub-sub-menus/{id}',
            [
                'controller' => 'Menus',
                'action' => 'subSubMenus',
                'section' => 'services'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/services/pending-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'pendingSubSubMenu',
                'section' => 'services'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/services/enabled-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'enabledSubSubMenu',
                'section' => 'services'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/services/disabled-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'disabledSubSubMenu',
                'section' => 'services'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/services/edited-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'editedSubSubMenu',
                'section' => 'services'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/services/sub-sub-menus/{id}',
            [
                'controller' => 'Menus',
                'action' => 'subSubMenus',
                'section' => 'services'
            ],
            [
                'pass' => ['services', 'id']
            ]
        );


        $builder->connect(
            '/services/disable-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'disableMenu',
                'section' => 'services'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/services/enable-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'enableMenu',
                'section' => 'services'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/services/show-menu-on-home/{id}',
            ['controller' => 'Menus', 'action' => 'showMenuOnHome'],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/services/remove-menu-from-home/{id}',
            ['controller' => 'Menus', 'action' => 'removeMenuFromHome'],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/services/show-menu-on-footer/{id}',
            ['controller' => 'Menus', 'action' => 'showMenuOnFooter'],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/services/remove-menu-from-footer/{id}',
            ['controller' => 'Menus', 'action' => 'removeMenuFooter'],
            [
                'pass' => ['id']
            ]
        );


        $builder->connect(
            '/about-us/remove-menu-from-home/{id}',
            ['controller' => 'Menus', 'action' => 'removeMenuFromHome'],
            [
                'pass' => ['id']
            ]
        );
        $builder->connect(
            '/about-us/show-menu-on-home/{id}',
            ['controller' => 'Menus', 'action' => 'showMenuOnHome'],
            [
                'pass' => ['id']
            ]
        );
        /** Menu re rounting End here **/

        $builder->connect(
            '/services/{action}',
            [
                'controller' => 'Services',
            ]
        );

        $builder->connect(
            '/services/{action}/{id}',
            [
                'controller' => 'Services',
            ],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/services/{action}/{id}/{cid}',
            [
                'controller' => 'Services',
            ],
            [
                'pass' => ['id', 'cid']
            ]
        );

        $builder->connect(
            '/services/{action}/{id}/{cid}/{pcid}',
            [
                'controller' => 'Services',
            ],
            [
                'pass' => ['id', 'cid', 'pcid']
            ]
        );

        /**
         * Set routes for standard controllers already defined for specific sections
         * from the matching the route
         * Route for Contact us
         * 1. Contact us provides the contact details for update
         */
        // Section: ContactUs
        $builder->connect(
            '/contact-us',
            [
                'controller' => 'ContactUs',
            ]
        );

        /**
         * Set routes for standard controllers already defined for specific sections
         * from the matching the route
         * Website information including name, logo, etc ...
         * 1. Update the global information for the website
         */
        // Section: ContactUs
        $builder->connect(
            '/settings',
            [
                'controller' => 'Settings',
            ]
        );

        $builder->connect(
            '/settings/mainMenuListings',
            [
                'controller' => 'Settings',
                'action' => 'mainMenuListings'

            ]
        );

        $builder->connect(
            '/settings/mainMenuListings/show-on-footer/{id}',
            ['controller' => 'Menus', 'action' => 'showOnFooter'],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/settings/mainMenuListings/show-on-top-nav/{id}',
            ['controller' => 'Menus', 'action' => 'showOnTopNav'],
            [
                'pass' => ['id']
            ]
        );


        $builder->connect(
            '/settings/mainMenuListings/remove-from-top-nav/{id}',
            ['controller' => 'Menus', 'action' => 'removeFromTopNav'],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/settings/mainMenuListings/remove-from-footer/{id}',
            ['controller' => 'Menus', 'action' => 'removeFromFooter'],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/settings/updateSiteName',
            [
                'controller' => 'Settings',
                'action' => 'updateSiteName'
            ]
        );

        $builder->connect(
            '/settings/pendingMenu',
            [
                'controller' => 'Settings',
                'action' => 'pendingMenu'
            ]
        );

        $builder->connect(
            '/settings/enableMenu',
            [
                'controller' => 'Settings',
                'action' => 'enableMenu'
            ]
        );

        $builder->connect(
            '/settings/disableMenu',
            [
                'controller' => 'Settings',
                'action' => 'disableMenu'
            ]
        );

        $builder->connect(
            '/settings/edited-menu',
            [
                'controller' => 'Settings',
                'action' => 'editedMenu'
            ],
        );

        $builder->connect(
            '/settings/add-menu',
            [
                'controller' => 'Settings',
                'action' => 'addMenu'
            ],
        );

        $builder->connect(
            '/settings/edit-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'editMenu'
            ],
            [
                'pass' => ['id']
            ]
        );






        /**
         * This route should have been taken care of from {section} menu above
         * but some home it doesnt execute the routes sequentially, it seems to have
         * priority levels with the construction before top down sequence.
         * So recreate the menu routes for each section with a controller created for it
         */
        $builder->connect(
            '/contact-us/add-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'addSubMenu',
                'section' => 'contact-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/contact-us/edit-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'editSubMenu',
                'section' => 'contact-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/contact-us/edit-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'editSubSubMenu',
                'section' => 'contact-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/contact-us/sub-menus/{id}',
            [
                'controller' => 'Menus',
                'action' => 'subMenus',
                'section' => 'contact-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/contact-us/add-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'addSubSubMenu',
                'section' => 'contact-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/contact-us/sub-sub-menus/{id}',
            [
                'controller' => 'Menus',
                'action' => 'subSubMenus',
                'section' => 'contact-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/contact-us/disable-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'disableMenu',
                'section' => 'contact-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/contact-us/enable-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'enableMenu',
                'section' => 'contact-us'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );
        $builder->connect(
            '/contact-us/remove-menu-from-home/{id}',
            ['controller' => 'Menus', 'action' => 'removeMenuFromHome'],
            [
                'pass' => ['id']
            ]
        );
        $builder->connect(
            '/contact-us/show-menu-on-home/{id}',
            ['controller' => 'Menus', 'action' => 'showMenuOnHome'],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/contact-us/show-menu-on-footer/{id}',
            ['controller' => 'Menus', 'action' => 'showMenuOnFooter'],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/contact-us/remove-menu-from-footer/{id}',
            ['controller' => 'Menus', 'action' => 'removeMenuFooter'],
            [
                'pass' => ['id']
            ]
        );
        /** Menu re rounting End here **/

        $builder->connect(
            '/contact-us/{action}',
            [
                'controller' => 'ContactUs',
            ]
        );

        $builder->connect(
            '/contact-us/{action}/{id}',
            [
                'controller' => 'ContactUs',
            ],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/contact-us/{action}/{id}/{cid}',
            [
                'controller' => 'ContactUs',
            ],
            [
                'pass' => ['id', 'cid']
            ]
        );

        $builder->connect(
            '/contact-us/{action}/{id}/{cid}/{pcid}',
            [
                'controller' => 'ContactUs',
            ],
            [
                'pass' => ['id', 'cid', 'pcid']
            ]
        );

        /**
         * Set routes for standard controllers already defined for specific sections
         * from the matching the route
         * Basic contents supports
         * 1. Listing (All, Pending, Enable, Disable, Edited)
         * 2. Add new item
         * 3. Edit item
         * 4. Enable item
         * 5. Disable item
         */
        // Section: Banners
        $builder->connect(
            '/banners',
            [
                'controller' => 'Banners',
            ]
        );

        $builder->connect(
            '/banners/{action}',
            [
                'controller' => 'Banners',
            ]
        );

        $builder->connect(
            '/banners/{action}/{id}',
            [
                'controller' => 'Banners',
            ],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/banners/{action}/{id}/{cid}',
            [
                'controller' => 'Banners',
            ],
            [
                'pass' => ['id', 'cid']
            ]
        );

        $builder->connect(
            '/banners/{action}/{id}/{cid}/{pcid}',
            [
                'controller' => 'Banners',
            ],
            [
                'pass' => ['id', 'cid', 'pcid']
            ]
        );
        $builder->connect(
            '/banners/order-banner',
            [
                'controller' => 'Banners',
                'action' => 'orderBanner'
            ]
        );
        $builder->connect(
            '/banners/list-banners',
            [
                'controller' => 'Banners',
                'action' => 'listBanners'
            ]
        );
        $builder->connect(
            '/banners/disable-order-value/{id}',
            [
                'controller' => 'Banners',
                'action' => 'disableOrderValue',
            ],
            [
                'pass' => ['id']
            ]
        );
        $builder->connect(
            '/banners/enable-order-value/{id}',
            [
                'controller' => 'Banners',
                'action' => 'enableOrderValue',
            ],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/banners/disabled-banner-items',
            [
                'controller' => 'Banners',
                'action' => 'disabledBannerItems',

            ]
        );
        /**
         * Set routes for Files uploading controllers
         * from the matching the route
         * Basic contents supports
         * 1. Listing (All, Pending, Enable, Disable, Edited)
         * 2. Add new item
         * 3. Edit item
         * 4. Enable item
         * 5. Disable item
         */
        // Section: File Uploads
        $builder->connect(
            '/file-uploads',
            [
                'controller' => 'FileUploads',
            ]
        );

        $builder->connect(
            '/file-uploads/{action}',
            [
                'controller' => 'FileUploads',
            ]
        );

        $builder->connect(
            '/file-uploads/{action}/{id}',
            [
                'controller' => 'FileUploads',
            ],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/file-uploads/{action}/{id}/{cid}',
            [
                'controller' => 'FileUploads',
            ],
            [
                'pass' => ['id', 'cid']
            ]
        );

        $builder->connect(
            '/file-uploads/{action}/{id}/{cid}/{pcid}',
            [
                'controller' => 'FileUploads',
            ],
            [
                'pass' => ['id', 'cid', 'pcid']
            ]
        );

        /**
         * Set routes for standard controllers already defined for specific sections
         * from the matching the route
         * Basic contents supports
         * 1. Listing (All, Pending, Enable, Disable, Edited)
         * 2. Add new item
         * 3. Edit item
         * 4. Enable item
         * 5. Disable item
         */
        // Section: Gallery
        $builder->connect(
            '/gallery/index',
            [
                'controller' => 'Gallery',
            ]
        );

        $builder->connect(
            '/gallery/{action}',
            [
                'controller' => 'Gallery',
            ]
        );

        $builder->connect(
            '/gallery/{action}/{id}',
            [
                'controller' => 'Gallery',
            ],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/gallery/{action}/{id}/{cid}',
            [
                'controller' => 'Gallery',
            ],
            [
                'pass' => ['id', 'cid']
            ]
        );

        $builder->connect(
            '/gallery/{action}/{id}/{cid}/{pcid}',
            [
                'controller' => 'Gallery',
            ],
            [
                'pass' => ['id', 'cid', 'pcid']
            ]
        );

        /**
         * Set routes for standard controllers already defined for specific sections
         * from the matching the route
         * Basic contents supports
         * 1. Listing (All, Pending, Enable, Disable, Edited)
         * 2. Add new item
         * 3. Edit item
         * 4. Enable item
         * 5. Disable item
         */
        // Section: Rooms
        $builder->connect(
            '/rooms',
            [
                'controller' => 'Rooms',
            ]
        );

        /**
         * This route should have been taken care of from {section} menu above
         * but some home it doesnt execute the routes sequentially, it seems to have
         * priority levels with the construction before top down sequence.
         * So recreate the menu routes for each section with a controller created for it
         */
        $builder->connect(
            '/rooms/add-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'addSubMenu',
                'section' => 'rooms'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/rooms/edit-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'editSubMenu',
                'section' => 'rooms'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/rooms/edit-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'editSubSubMenu',
                'section' => 'rooms'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/rooms/sub-menus/{id}',
            [
                'controller' => 'Menus',
                'action' => 'subMenus',
                'section' => 'rooms'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/rooms/add-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'addSubSubMenu',
                'section' => 'rooms'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/rooms/sub-sub-menus/{id}',
            [
                'controller' => 'Menus',
                'action' => 'subSubMenus',
                'section' => 'rooms'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/rooms/disable-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'disableMenu',
                'section' => 'rooms'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/rooms/enable-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'enableMenu',
                'section' => 'rooms'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/rooms/remove-menu-from-home/{id}',
            ['controller' => 'Menus', 'action' => 'removeMenuFromHome'],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/rooms/show-menu-on-home/{id}',
            ['controller' => 'Menus', 'action' => 'showMenuOnHome'],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/rooms/show-menu-on-footer/{id}',
            ['controller' => 'Menus', 'action' => 'showMenuOnFooter'],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/rooms/remove-menu-from-footer/{id}',
            ['controller' => 'Menus', 'action' => 'removeMenuFooter'],
            [
                'pass' => ['id']
            ]
        );

        /** Menu re rounting End here **/

        $builder->connect(
            '/rooms/{action}',
            [
                'controller' => 'Rooms',
            ]
        );

        $builder->connect(
            '/rooms/{action}/{id}',
            [
                'controller' => 'Rooms',
            ],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/rooms/{action}/{id}/{cid}',
            [
                'controller' => 'Rooms',
            ],
            [
                'pass' => ['id', 'cid']
            ]
        );

        $builder->connect(
            '/rooms/{action}/{id}/{cid}/{pcid}',
            [
                'controller' => 'Rooms',
            ],
            [
                'pass' => ['id', 'cid', 'pcid']
            ]
        );

        /**
         * Set routes for standard controllers already defined for specific sections
         * from the matching the route
         * Basic contents supports
         * 1. Listing (All, Pending, Enable, Disable, Edited)
         * 2. Add new item
         * 3. Edit item
         * 4. Enable item
         * 5. Disable item
         */
        // Section: Products

        $builder->connect(
            '/products',
            [
                'controller' => 'Products',
            ]
        );


        /**
         * This route should have been taken care of from {section} menu above
         * but some home it doesnt execute the routes sequentially, it seems to have
         * priority levels with the construction before top down sequence.
         * So recreate the menu routes for each section with a controller created for it
         */

        $builder->connect(
            '/products/add-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'addSubMenu',
                'section' => 'products'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/products/pending-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'pendingSubMenu',
                'section' => 'products'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/products/enabled-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'enabledSubMenu',
                'section' => 'products'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/products/disabled-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'disabledSubMenu',
                'section' => 'products'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/products/edited-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'editedSubMenu',
                'section' => 'products'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/products/edit-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'editSubMenu',
                'section' => 'products'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/products/edit-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'editSubSubMenu',
                'section' => 'products'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/products/sub-menus/{id}',
            [
                'controller' => 'Menus',
                'action' => 'subMenus',
                'section' => 'products'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/products/add-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'addSubSubMenu',
                'section' => 'products'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/products/sub-sub-menus/{id}',
            [
                'controller' => 'Menus',
                'action' => 'subSubMenus',
                'section' => 'products'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/products/disable-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'disableMenu',
                'section' => 'products'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/products/enable-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'enableMenu',
                'section' => 'products'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/products/pending-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'pendingSubSubMenu',
                'section' => 'products'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/products/enabled-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'enabledSubSubMenu',
                'section' => 'products'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/products/enabled-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'enabledSubSubMenu',
                'section' => 'products'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/products/disabled-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'disabledSubSubMenu',
                'section' => 'products'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        $builder->connect(
            '/products/edited-sub-sub-menu/{id}',
            [
                'controller' => 'Menus',
                'action' => 'editedSubSubMenu',
                'section' => 'products'
            ],
            [
                'pass' => ['section', 'id']
            ]
        );

        /** Menu re rounting End here **/

        $builder->connect(
            '/products/{action}',
            [
                'controller' => 'Products',
            ]
        );

        $builder->connect(
            '/products/{action}/{id}',
            [
                'controller' => 'Products',
            ],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/products/{action}/{id}/{cid}',
            [
                'controller' => 'Products',
            ],
            [
                'pass' => ['id', 'cid']
            ]
        );

        $builder->connect(
            '/products/show-menu-on-footer/{id}',
            ['controller' => 'Menus', 'action' => 'showMenuOnFooter'],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/products/remove-menu-from-footer/{id}',
            ['controller' => 'Menus', 'action' => 'removeMenuFooter'],
            [
                'pass' => ['id']
            ]
        );

        // My Account
        $builder->connect(
            '/Memebers',
            [
                'controller' => 'Memebers',
            ]
        );

        $builder->connect(
            '/ghisep-memebers/approve/{id}',
            [
                'controller' => 'GhisepMemebers',
                'action' => 'approve',
            ]
        );

        $builder->connect(
            '/ghisep-memebers/view/{id}',
            [
                'controller' => 'GhisepMemebers',
                'action' => 'view',
            ],
            [
                'pass' => ['id']
            ]
        );


        // Fallback routes for the base content. to render menus without controllers and templates

        /**
         * Set the fallback controller to BaseContents, when no matching controller is found
         * from the matching the route
         * Basic contents supports
         * 1. Listing (All, Pending, Enable, Disable, Edited)
         * 2. Add new item
         * 3. Edit item
         * 4. Enable item
         * 5. Disable item
         */
        $builder->connect(
            '/{section}',
            [
                'controller' => 'BaseContent',
            ]
        );

        $builder->connect(
            '/{section}/{action}',
            [
                'controller' => 'BaseContent',
            ]
        );

        $builder->connect(
            '/{section}/{action}/{id}',
            [
                'controller' => 'BaseContent',
            ],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/{section}/{action}/{id}/{cid}',
            [
                'controller' => 'BaseContent',
            ],
            [
                'pass' => ['id', 'cid']
            ]
        );

        $builder->connect(
            '/{section}/{action}/{id}/{cid}/{pcid}',
            [
                'controller' => 'BaseContent',
            ],
            [
                'pass' => ['id', 'cid', 'pcid']
            ]
        );


        $builder->connect(
            '/home/ghisep-memebers/{id}',
            [
                'controller' => 'GhisepMemebers',
                'action' => 'approve',
                // 'section' => 'home'
            ],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/home/ghisep-memebers/disapprove/{id}',
            [
                'controller' => 'GhisepMemebers',
                'action' => 'disapprove',
                // 'section' => 'home'
            ],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/memebers/view/{id}',
            [
                'controller' => 'Memebers',
                'action' => 'view',
                // 'section' => 'home'
            ],
            [
                'pass' => ['id']
            ]
        );


        $builder->connect(
            '/ghisep-memebers/pendingmembers',
            [
                'controller' => 'GhisepMemebers',
                'action' => 'pendingmembers',
            ],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/ghisep-memebers/approvedmembers',
            [
                'controller' => 'GhisepMemebers',
                'action' => 'approvedmembers',
            ],
            [
                'pass' => ['id']
            ]
        );


        $builder->connect(
            '/ghisep-memebers/disabledmembers',
            [
                'controller' => 'GhisepMemebers',
                'action' => 'disabledmembers',
            ],
            [
                'pass' => ['id']
            ]
        );
        $builder->connect(
            '/contents/add-image/{id}',
            ['controller' => 'Contents', 'action' => 'addImage'],
            [
                'pass' => ['id']
            ]
        );

        // $builder->connect(
        // '/contents/search',
        // ['controller' => 'Contents', 'action' => 'search'],
        // );

        $builder->connect(
            '/ghisep-memebers/editedmembers',
            [
                'controller' => 'GhisepMemebers',
                'action' => 'editedmembers',
            ],
            [
                'pass' => ['id']
            ]
        );

        $builder->connect(
            '/dropzone',
            ['controller' => 'Content', 'action' => 'addImage']
        );

        /*
         * Connect catchall routes for all controllers.
         *
         * The `fallbacks` method is a shortcut for
         *
         * ```
         * $builder->connect('/{controller}', ['action' => 'index']);
         * $builder->connect('/{controller}/{action}/*', []);
         * ```

         * You can remove these routes once you've connected the
         * routes you want in your application.
         */
        $builder->fallbacks();
    });

    /*
     * If you need a different set of middleware or none at all,
     * open new scope and define routes there.
     *
     * ```
     * $routes->scope('/api', function (RouteBuilder $builder): void {
     *     // No $builder->applyMiddleware() here.
     *
     *     // Parse specified extensions from URLs
     *     // $builder->setExtensions(['json', 'xml']);
     *
     *     // Connect API actions here.
     * });
     * ```
     */
    // Section: Members

};
