<?php

namespace App\Controller;

use App\Controller\AppController;
use cake\ORM\TableRegistry;
use Cake\I18n\Time;
use Cake\Event\EventInterface;
use Cake\Core\Configure;
use Cake\Log\Log;
use Cake\Http\Exception\NotFoundException;

/**
 * Items Controller
 *
 * @property \App\Model\Table\ItemsTable $Items and AutoSparePartsTable $AutoSpareParts
 */
class GalleryController extends AppController
{
    public function initialize(): void
    {
        parent::initialize();

        $this->albums = $this->fetchTable('Albums');
        $this->galleries = $this->fetchTable('Galleries');
    }

    public function beforeRender(EventInterface $event)
    {
        parent::beforeRender($event);
    }

    /**
     * Display all images.
     *
     * @return \Cake\Http\Response|null Renders the view
     */
    public function index()
    {
        $pageTitle = 'All Images';
        $listings = $this->albums->findAllAlbums();
        $this->set(compact('pageTitle', 'listings'));
    }

    public function add()
    {
        $albums = $this->albums->selectAlbums();
        $uploaded = false;
        $pageTitle = 'Upload Image';

        if ($this->request->is(['post'])) {
            $data = $this->request->getData();

            foreach ($data['files'] as $image) {

                if (isset($image)) {

                    $cmsbanners = $this->galleries->newEmptyEntity();
                    // $fileOK = $this->uploadFiles(Configure::read('IMAGE_PREPATH', '') , $image);
                    $fileOK = $this->uploadFiles(Configure::read('IMAGE_PREPATH', '') . 'gallery/', $image);

                    if (!empty($fileOK['urls'])) {
                        $data['image_path'] = substr($fileOK['file_path'][0], Configure::read('IMAGE_PRELENGTH', '0'), strlen($fileOK['file_path'][0]));
                        $imgName = $image->getClientFilename();
                        $data['name'] = str_replace(['_', '-', ':', '\\', '/', '*'], ' ', $imgName);
                    }
                }

                $cmsbanners = $this->galleries->patchEntity($cmsbanners, $data);
                $this->galleries->save($cmsbanners);
                $uploaded = true;
            }

            if ($uploaded) {
                $this->Flash->success(__('Banner Uploaded successfully.'));
                return $this->redirect(['action' => 'pendingListings']);
            } else {
                $this->Flash->error(__('The row could not be save. Try again'));
            }
        }
        $menu_id = "";
        $this->set(compact('pageTitle', 'menu_id', 'albums'));

    }

    public function allListings()
    {
        $pageTitle = 'All Images';
        $listings = $this->albums->allListings();
        $this->set(compact('pageTitle', 'listings'));
    }

    public function pendingListings()
    {
        $pageTitle = 'Pending Images';
        $listings = $this->galleries->pendingListings();
        $this->set(compact('pageTitle', 'listings'));
    }

    public function enableListings()
    {
        $pageTitle = 'Enabled Images';
        $listings = $this->galleries->enableListings();
        $this->set(compact('pageTitle', 'listings'));
    }

    public function disableListings()
    {
        $pageTitle = 'Enabled Images';
        $listings = $this->galleries->disableListings();
        $this->set(compact('pageTitle', 'listings'));
    }

  public function enable($id = null)
    {
        $result = $this->galleries->enable($id);

        if ($result) {
            $this->Flash->success(__('Content has been DISABLED successfully.'));
        } else {
            throw new NotFoundException(__('Content not found or already disabled.'));
        }

        return $this->redirect($this->referer());
    }

    public function disable($id = null)
    {
        $result = $this->galleries->disable($id);

        if ($result) {
            $this->Flash->success(__('Content has been DISABLED successfully.'));
        } else {
            throw new NotFoundException(__('Content not found or already disabled.'));
        }

        return $this->redirect($this->referer());
    }

  public function remove($id = null)
{
    $this->viewBuilder()->setLayout(false);

    // Fetch the record
    $gallery = $this->galleries->get($id);

    // Get full image path
    $imagePath = Configure::read('IMAGE_PREPATH', '') . $gallery->image_path;

    // Try to delete the file if it exists
    if (file_exists($imagePath)) {
        unlink($imagePath); // delete the image file
    }

    // Try to delete the database record
    if ($this->galleries->delete($gallery)) {
        $this->Flash->success(__('Image and record removed successfully.'));
    } else {
        $this->Flash->error(__('Failed to remove database record.'));
    }

    return $this->redirect($this->referer());
}


    public function details($album_id = null)
    {
        $pageTitle = 'All Images';

        // Load the gallery records
        // Lets get all the pictures
        $galleryDetails = $this->galleries->find('all', [
            'conditions' => [
                'status' => 1,
                'album_id' => $album_id
            ]
        ]);

        $galleryDetails = $this->paginate($galleryDetails);

        $this->set(compact('pageTitle', 'galleryDetails'));
    }

}