<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Content $content
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Content'), ['action' => 'edit', $content->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Content'), ['action' => 'delete', $content->id], ['confirm' => __('Are you sure you want to delete # {0}?', $content->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Contents'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Content'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="contents view content">
            <h3><?= h($content->name) ?></h3>
            <table>
                <tr>
                    <th><?= __('Name') ?></th>
                    <td><?= h($content->name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Caption') ?></th>
                    <td><?= h($content->caption) ?></td>
                </tr>
                <tr>
                    <th><?= __('Image Path') ?></th>
                    <td><?= h($content->image_path) ?></td>
                </tr>
                <tr>
                    <th><?= __('File Path') ?></th>
                    <td><?= h($content->file_path) ?></td>
                </tr>
                <tr>
                    <th><?= __('Level') ?></th>
                    <td><?= h($content->level) ?></td>
                </tr>
                <tr>
                    <th><?= __('Fa Icon') ?></th>
                    <td><?= h($content->fa_icon) ?></td>
                </tr>
                <tr>
                    <th><?= __('Info1') ?></th>
                    <td><?= h($content->info1) ?></td>
                </tr>
                <tr>
                    <th><?= __('Map Address') ?></th>
                    <td><?= h($content->map_address) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($content->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Status') ?></th>
                    <td><?= $this->Number->format($content->status) ?></td>
                </tr>
                <tr>
                    <th><?= __('Show On Home') ?></th>
                    <td><?= $content->show_on_home === null ? '' : $this->Number->format($content->show_on_home) ?></td>
                </tr>
                <tr>
                    <th><?= __('Order Value') ?></th>
                    <td><?= $content->order_value === null ? '' : $this->Number->format($content->order_value) ?></td>
                </tr>
                <tr>
                    <th><?= __('Date Created') ?></th>
                    <td><?= h($content->date_created) ?></td>
                </tr>
                <tr>
                    <th><?= __('Date Modified') ?></th>
                    <td><?= h($content->date_modified) ?></td>
                </tr>
            </table>
            <div class="text">
                <strong><?= __('Content') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($content->content)); ?>
                </blockquote>
            </div>
            <div class="related">
                <h4><?= __('Related Content Images') ?></h4>
                <?php if (!empty($content->content_images)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Image Path') ?></th>
                            <th><?= __('Caption') ?></th>
                            <th><?= __('Content Id') ?></th>
                            <th><?= __('Date Created') ?></th>
                            <th><?= __('Date Modified') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($content->content_images as $contentImage) : ?>
                        <tr>
                            <td><?= h($contentImage->id) ?></td>
                            <td><?= h($contentImage->image_path) ?></td>
                            <td><?= h($contentImage->caption) ?></td>
                            <td><?= h($contentImage->content_id) ?></td>
                            <td><?= h($contentImage->date_created) ?></td>
                            <td><?= h($contentImage->date_modified) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'ContentImages', 'action' => 'view', $contentImage->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'ContentImages', 'action' => 'edit', $contentImage->id]) ?>
                                <?= $this->Form->postLink(
                                    __('Delete'),
                                    ['controller' => 'ContentImages', 'action' => 'delete', $contentImage->id],
                                    [
                                        'method' => 'delete',
                                        'confirm' => __('Are you sure you want to delete # {0}?', $contentImage->id),
                                    ]
                                ) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
            <div class="related">
                <h4><?= __('Related Page Contents') ?></h4>
                <?php if (!empty($content->page_contents)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Menu Id') ?></th>
                            <th><?= __('Content Id') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($content->page_contents as $pageContent) : ?>
                        <tr>
                            <td><?= h($pageContent->id) ?></td>
                            <td><?= h($pageContent->menu_id) ?></td>
                            <td><?= h($pageContent->content_id) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'PageContents', 'action' => 'view', $pageContent->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'PageContents', 'action' => 'edit', $pageContent->id]) ?>
                                <?= $this->Form->postLink(
                                    __('Delete'),
                                    ['controller' => 'PageContents', 'action' => 'delete', $pageContent->id],
                                    [
                                        'method' => 'delete',
                                        'confirm' => __('Are you sure you want to delete # {0}?', $pageContent->id),
                                    ]
                                ) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>