<div class="bg-light shadow-sm py-3 mb-3 rounded-3">

    <div class="row justify-content-center ">
        <div class="col-12 col-lg-12 px-4">

            <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap">
                <?= $this->Paginator->limitControl(
                    [10 => 10, 25 => 25, 50 => 50, 100 => 100],
                    null,
                    [
                        'label' => 'Items per page:',
                        'class' => 'form-select w-auto d-inline-block ms-2'
                    ]
                ); ?>

                <?= $this->Form->create(null,['type' => 'get', 'class' => 'd-flex justify-content-end mt-2 mt-md-0']) ?>
                <?= $this->Form->control('search', [
                    'type' => 'text',
                    'label' => false,
                    'placeholder' => 'Search',
                    'id' => 'customSearch',
                    'value' => $searchTerm ?? '',
                    'class' => 'form-control me-2 w-auto'
                ]) ?>
                <?= $this->Form->button('Search', ['type' => 'submit', 'id' => 'searchBtn', 'class' => 'btn btn-primary']) ?>
                <?= $this->Form->end() ?>
            </div>

            <table class="table table-stripeds table-hover">

                <thead>
                    <th>Name</th>
                    <th>Descriptions</th>
                    <th>Content</th>
                    <!-- <th>Home</th> -->
                    <th>Order Value</th>
                    <th>Image</th>
                    <th>Actions</th>
                </thead>

                <tbody class="table-group-divider">
                    <?php foreach ($listings as $listing): ?>
                        <?php $img = Cake\Core\Configure::read('IMAGE_PREPATH') . $listing->image_path; ?>
                        <tr>
                            <td><?= $listing->name ?></td>
                            <td><?= $listing->description ?></td>
                            

                            <td data-label="Content" style="width: 30%;">
                                <?= $this->Text->truncate(strip_tags($listing->content), 150, ['ellipsis' => '...', 'exact' => false]) ?>
                            </td>
                            
                            <!-- <td></?= $listing->show_on_home == 1 ? 'Yes' : 'No' ?></td> -->

                            <td><?= $listing->order_value ?></td>
                            
                            <td>
                                <?= isset($listing->image_path) && trim($listing->image_path) != '' ? '<a href="' . $this->Url->image($img) . '">' . $this->Html->image($img, ['height' => '70px']) . '</a>' : '' ?>
                            </td>

                            <td>
                                <div class="d-flex flex-wrap gap-1">
                                    <!-- Edit -->
                                    <?= $this->Html->link(
                                        '<i class="bi bi-pencil-square"></i>',
                                        ['controller' => $slug, 'action' => 'editMenu', $listing->id],
                                        ['class' => 'btn btn-sm btn-outline-info', 'escape' => false, 'title' => 'Edit', 'data-bs-toggle' => 'tooltip']
                                    ) ?>

                                    <!-- Enable / Disable -->
                                    <?php if ($listing->status == 1): ?>
                                        <?= $this->Html->link(
                                            '<i class="bi bi-x-circle"></i>',
                                            ['controller' => $slug, 'action' => 'disableMenu', $listing->id],
                                            ['class' => 'btn btn-sm btn-outline-danger', 'escape' => false, 'title' => 'Disable', 'data-bs-toggle' => 'tooltip']
                                        ) ?>
                                    <?php else: ?>

                                        <?= $this->Html->link(
                                            '<i class="bi bi-check-circle"></i>',
                                            ['controller' => $slug, 'action' => 'enableMenu', $listing->id],
                                            ['class' => 'btn btn-sm btn-outline-success', 'escape' => false, 'title' => 'Enable', 'data-bs-toggle' => 'tooltip']
                                        ) ?>
                                    <?php endif ?>

                                    <!-- Home -->
                                    <?php if ($listing->show_on_home == 1): ?>
                                        <?= $this->Html->link(
                                            '<i class="bi bi-house-x"></i>',
                                            ['controller' => $slug, 'action' => 'removeMenuFromHome', $listing->id],
                                            ['class' => 'btn btn-sm btn-outline-warning', 'escape' => false, 'title' => 'Remove from Home', 'data-bs-toggle' => 'tooltip']
                                        ) ?>
                                    <?php else: ?>
                                        <?= $this->Html->link(
                                            '<i class="bi bi-house-door"></i>',
                                            ['controller' => $slug, 'action' => 'showMenuOnHome', $listing->id],
                                            ['class' => 'btn btn-sm btn-outline-primary', 'escape' => false, 'title' => 'Show on Home', 'data-bs-toggle' => 'tooltip']
                                        ) ?>
                                    <?php endif; ?>

                                </div>
                            </td>

                        </tr>
                    <?php endforeach; ?>
                </tbody>

            </table>

            <?php echo $this->element('pagination'); ?>

        </div>
    </div>
</div>