<?php

namespace App\Controller;

use App\Controller\AppController;
use cake\ORM\TableRegistry;
use Cake\I18n\Time;
use Cake\Event\EventInterface;
use Cake\Core\Configure;
use Cake\Log\Log;

/**
 * Items Controller
 *
 * @property \App\Model\Table\ItemsTable $Items and AutoSparePartsTable $AutoSpareParts
 */
class BannersController extends AppController
{
    public function initialize(): void
    {
        parent::initialize();

    }

    public function beforeRender(EventInterface $event)
    {
        parent::beforeRender($event);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->getParam('action');
        return true;
    }


    public function index($slug = null)
    {
        $pageTitle = '';
        $pageSubTitle = 'Home Page';
        $pageContentTitle = 'All Banners';
        $orderQuery = null;

        $bannerSchema = $this->Banners->getSchema();
        // Get all columns from the menu schema
        $allColumns = $bannerSchema->columns();
        // Check if the 'section_id' column exists
        $sectionIdColumnExists = in_array('section_id', $allColumns);
        $orderValueColumnExists = in_array('order_value', $allColumns);

        $bannerQueryOptions = [
            'conditions' => ['status' => 1]
        ];

        if ($sectionIdColumnExists) {
            $bannerQueryOptions['conditions']['Banners.section_id'] = 1;
        }

        if ($orderValueColumnExists) {
            $orderQuery = ['order_value' => 'Asc'];
        }

        $llistings = $this->Banners->find('all', $bannerQueryOptions)->order($orderQuery);

        $listings = $this->paginate($llistings);
        $this->set(compact('pageTitle', 'listings', 'pageSubTitle', 'pageContentTitle'));

    }

    public function add()
    {
        $cmsbanners = $this->Banners->newEmptyEntity();
        $sectionlist = $this->Menus->find('all')->where(['status' => 1]);
        $pageTitle = '';
        $pageSubTitle = 'Home Page';
        $pageContentTitle = 'Add Home Banners';

        if ($this->request->is(['post'])) {
            $data = $this->request->getData();
            $image_field = 'image1';
            $image_path = $this->request->getData($image_field);
            $imageSize = $image_path->getSize();

            // Check if there is an image and then update the image path
            if ($imageSize > 0) {
                $fileOK = $this->uploadFiles(Configure::read('IMAGE_PREPATH'), $data['image1']);

                if (!empty($fileOK['urls'])) {
                    $data['image_path'] = substr(
                        $fileOK['file_path'][0],
                        Configure::read('IMAGE_PRELENGTH'),
                        strlen($fileOK['file_path'][0])
                    );
                }
            } else {
                $data['image1'] = 'temp';
            }

            $data['section_id'] = 1;

            $cmsbanners = $this->Banners->patchEntity($cmsbanners, $data);

            if ($this->Banners->save($cmsbanners)) {
                $this->Flash->success(__('Banners added successfully.'));
                return $this->redirect(['action' => 'pendingListings']);

            } else {
                $this->Flash->error(__('The row could not be save. Try again'));
            }
        }

        $this->set(compact('pageTitle', 'cmsbanners', 'sectionlist', 'pageSubTitle', 'pageContentTitle'));
    }

    public function edit($id)
    {
        $pageTitle = '';
        $pageSubTitle = 'Home ';
        $pageContentTitle = 'Edit Home Banners';
        $cmsbanners = $this->Banners->get($id);
        $sectionlist = $this->Menus->find('all')->where(['status' => 1]);

        if ($this->request->is(['post', 'put', 'patch'])) {
            $data = $this->request->getData();
            $image_field = 'image1';
            $image_path = $this->request->getData($image_field);
            $imageSize = $image_path->getSize();

            if (isset($data[$image_field])) {
                $fileOK = $this->uploadFiles(Configure::read('IMAGE_PREPATH'), $data[$image_field], null, null, false);
                if (!empty($fileOK['urls'])) {
                    $data['image_path'] = substr(
                        $fileOK['file_path'][0],
                        Configure::read('IMAGE_PRELENGTH'),
                        strlen($fileOK['file_path'][0])
                    );
                }
            } else {
                $data['image_path'] = 'temp';
            }

            $data['status'] = 2;
            $cmsbanners = $this->Banners->patchEntity($cmsbanners, $data);

            if ($this->Banners->save($cmsbanners)) {
                $this->Flash->success(__('banners added successfully.'));
                return $this->redirect(['action' => 'editedListings']);
            } else {
                $this->Flash->error(__('The row could not be save. Try again'));
            }
        }
        $this->set(compact('pageTitle', 'pageContentTitle', 'cmsbanners', 'sectionlist', 'pageSubTitle'));
    }

    public function pendingListings()
    {
        // Initialize page variables
        $pageTitle = '';
        $pageSubTitle = 'Home';
        $pageContentTitle = 'Pending Banners';

        try {
            // Log the start of the pending listings process
            Log::debug('Fetching pending listings.');

            // Get schema of the Banners table
            $bannerSchema = $this->Banners->getSchema();
            // Get all columns from the banner schema
            $allColumns = $bannerSchema->columns();
            // Check if specific columns exist in the schema
            $sectionIdColumnExists = in_array('section_id', $allColumns);
            $orderValueColumnExists = in_array('order_value', $allColumns);

            // Set up query options for fetching pending banners
            $bannerQueryOptions = [
                'conditions' => ['status' => 0]
            ];

            // Add condition for section_id if it exists
            if ($sectionIdColumnExists) {
                $bannerQueryOptions['conditions']['Banners.section_id'] = 1;
            }

            // Fetch banners based on query options
            $listings = $this->paginate($this->Banners->find('all', $bannerQueryOptions));

            // Log successful fetch of pending listings
            Log::debug('Pending listings fetched successfully.', ['count' => $listings->count()]);

        } catch (\Exception $e) {
            // Log any exception that occurs
            Log::error('Error fetching pending listings', ['exception' => $e]);
            // Set an error flash message for the user
            $this->Flash->error(__('There was an error fetching the pending banners. Please try again later.'));
            // Set listings to an empty result set in case of error
            $listings = $this->Banners->newEmptyEntity();
        }

        // Set variables for the view
        $this->set(compact('pageTitle', 'listings', 'pageSubTitle', 'pageContentTitle'));
    }

    public function enabledListings()
    {
        // Initialize page variables
        $pageTitle = '';
        $pageSubTitle = 'Home';
        $pageContentTitle = 'Enable Banners';

        try {
            // Log the start of the enabled listings process
            Log::debug('Fetching enabled listings.');

            // Get schema of the Banners table
            $bannerSchema = $this->Banners->getSchema();
            // Get all columns from the banner schema
            $allColumns = $bannerSchema->columns();
            // Check if specific columns exist in the schema
            $sectionIdColumnExists = in_array('section_id', $allColumns);
            $orderValueColumnExists = in_array('order_value', $allColumns);

            // Set up query options for fetching enabled banners
            $bannerQueryOptions = [
                'conditions' => ['status' => 1]
            ];

            // Add condition for section_id if it exists
            if ($sectionIdColumnExists) {
                $bannerQueryOptions['conditions']['Banners.section_id'] = 1;
            }

            // Fetch banners based on query options
            $listings = $this->paginate($this->Banners->find('all', $bannerQueryOptions));

            // Log successful fetch of enabled listings
            Log::debug('Enabled listings fetched successfully.', ['count' => $listings->count()]);

        } catch (\Exception $e) {
            // Log any exception that occurs
            Log::error('Error fetching enabled listings', ['exception' => $e]);
            // Set an error flash message for the user
            $this->Flash->error(__('There was an error fetching the enabled banners. Please try again later.'));
            // Set listings to an empty result set in case of error
            $listings = $this->Banners->newEmptyEntity();
        }

        // Set variables for the view
        $this->set(compact('pageTitle', 'listings', 'pageSubTitle', 'pageContentTitle'));
    }

    public function disableListings()
    {
        // Initialize page variables
        $pageTitle = '';
        $pageSubTitle = 'Home';
        $pageContentTitle = 'Disabled Banners';

        try {
            // Log the start of the disable listings process
            Log::debug('Fetching disabled listings.');

            // Get schema of the Banners table
            $bannerSchema = $this->Banners->getSchema();
            // Get all columns from the banner schema
            $allColumns = $bannerSchema->columns();
            // Check if specific columns exist in the schema
            $sectionIdColumnExists = in_array('section_id', $allColumns);
            $orderValueColumnExists = in_array('order_value', $allColumns);

            // Set up query options for fetching disabled banners
            $bannerQueryOptions = [
                'conditions' => ['status' => 99]
            ];

            // Add condition for section_id if it exists
            if ($sectionIdColumnExists) {
                $bannerQueryOptions['conditions']['Banners.section_id'] = 1;
            }

            // Fetch banners based on query options
            $listings = $this->paginate($this->Banners->find('all', $bannerQueryOptions));

            // Log successful fetch of disabled listings
            Log::debug('Disabled listings fetched successfully.', ['count' => $listings->count()]);

        } catch (\Exception $e) {
            // Log any exception that occurs
            Log::error('Error fetching disabled listings', ['exception' => $e]);
            // Set an error flash message for the user
            $this->Flash->error(__('There was an error fetching the disabled banners. Please try again later.'));
            // Set listings to an empty result set in case of error
            $listings = $this->Banners->newEmptyEntity();
        }

        // Set variables for the view
        $this->set(compact('pageTitle', 'listings', 'pageContentTitle', 'pageSubTitle'));
    }

    public function editedListings()
    {
        // Initialize page variables
        $pageTitle = '';
        $pageSubTitle = 'Home';
        $pageContentTitle = 'Edited Banners';

        try {
            // Log the start of the edited listings process
            Log::debug('Fetching edited listings.');

            // Get schema of the Banners table
            $bannerSchema = $this->Banners->getSchema();
            // Get all columns from the banner schema
            $allColumns = $bannerSchema->columns();
            // Check if specific columns exist in the schema
            $sectionIdColumnExists = in_array('section_id', $allColumns);
            $orderValueColumnExists = in_array('order_value', $allColumns);

            // Set up query options for fetching edited banners
            $bannerQueryOptions = [
                'conditions' => ['status' => 2]
            ];

            // Add condition for section_id if it exists
            if ($sectionIdColumnExists) {
                $bannerQueryOptions['conditions']['Banners.section_id'] = 1;
            }

            // Fetch banners based on query options
            $listings = $this->paginate($this->Banners->find('all', $bannerQueryOptions));

            // Log successful fetch of edited listings
            Log::debug('Edited listings fetched successfully.', ['count' => $listings->count()]);

        } catch (\Exception $e) {
            // Log any exception that occurs
            Log::error('Error fetching edited listings', ['exception' => $e]);
            // Set an error flash message for the user
            $this->Flash->error(__('There was an error fetching the edited banners. Please try again later.'));
            // Set listings to an empty result set in case of error
            $listings = $this->Banners->newEmptyEntity();
        }

        // Set variables for the view
        $this->set(compact('pageTitle', 'listings', 'pageContentTitle', 'pageSubTitle'));
    }


    public function enable($id = null)
    {
        // Disable layout for this action
        $this->viewBuilder()->disableAutoLayout();

        try {
            // Log the start of the enable process
            Log::debug('Enabling banner.', ['id' => $id]);

            // Fetch the banner by ID
            $banner = $this->Banners->get($id);

            // Update the status to enabled
            $banner->status = 1;

            // Save the updated banner
            if ($this->Banners->save($banner)) {
                // Log successful save
                Log::debug('Banner enabled successfully.', ['id' => $id]);
                // Set success flash message
                $this->Flash->success(__('Banner enabled successfully.'));
            } else {
                // Log save error
                Log::error('Error enabling banner.', ['id' => $id, 'errors' => $banner->getErrors()]);
                // Set error flash message
                $this->Flash->error(__('Error occurred while enabling the banner.'));
            }
        } catch (\Exception $e) {
            // Log exception
            Log::error('Exception enabling banner.', ['id' => $id, 'exception' => $e]);
            // Set error flash message
            $this->Flash->error(__('An error occurred while enabling the banner. Please try again later.'));
        }

        // Redirect to the referring page
        return $this->redirect($this->referer());
    }


    public function disable($id = null)
    {
        // Disable layout for this action
        $this->viewBuilder()->disableAutoLayout();

        try {
            // Log the start of the disable process
            Log::debug('Disabling banner.', ['id' => $id]);

            // Fetch the banner by ID
            $banner = $this->Banners->get($id);

            // Update the status to disabled
            $this->request = $this->request->withData('status', 99);
            $banner = $this->Banners->patchEntity($banner, $this->request->getData());

            // Save the updated banner
            if ($this->Banners->save($banner)) {
                // Log successful save
                Log::debug('Banner disabled successfully.', ['id' => $id]);
                // Set success flash message
                $this->Flash->success(__('Banner disabled successfully.'));
            } else {
                // Log save error
                Log::error('Error disabling banner.', ['id' => $id, 'errors' => $banner->getErrors()]);
                // Set error flash message
                $this->Flash->error(__('Error occurred while disabling the banner.'));
            }
        } catch (\Exception $e) {
            // Log exception
            Log::error('Exception disabling banner.', ['id' => $id, 'exception' => $e]);
            // Set error flash message
            $this->Flash->error(__('An error occurred while disabling the banner. Please try again later.'));
        }

        // Redirect to the referring page
        return $this->redirect($this->referer());
    }

    public function removeFromFooter($id = null)
    {
        // Disable layout for this action
        $this->viewBuilder()->disableAutoLayout();

        try {
            // Log the start of the remove from footer process
            Log::debug('Removing banner from footer.', ['id' => $id]);

            // Fetch the banner by ID
            $banner = $this->Banners->get($id);

            // Update the show_on_footer field to 0
            $this->request = $this->request->withData('show_on_footer', 0);
            $banner = $this->Banners->patchEntity($banner, $this->request->getData());

            // Save the updated banner
            if ($this->Banners->save($banner)) {
                // Log successful save
                Log::debug('Banner removed from footer successfully.', ['id' => $id]);
                // Set success flash message
                $this->Flash->success(__('Banner successfully removed from footer.'));
            } else {
                // Log save error
                Log::error('Error removing banner from footer.', ['id' => $id, 'errors' => $banner->getErrors()]);
                // Set error flash message
                $this->Flash->error(__('Error occurred while removing the banner from the footer.'));
            }
        } catch (\Exception $e) {
            // Log exception
            Log::error('Exception removing banner from footer.', ['id' => $id, 'exception' => $e]);
            // Set error flash message
            $this->Flash->error(__('An error occurred while removing the banner from the footer. Please try again later.'));
        }

        // Redirect to the referring page
        return $this->redirect($this->referer());
    }

    public function showOnFooter($id = null)
    {
        // Disable layout for this action
        $this->viewBuilder()->disableAutoLayout();

        try {
            // Log the start of the show on footer process
            Log::debug('Showing banner on footer.', ['id' => $id]);

            // Fetch the banner by ID
            $banner = $this->Banners->get($id);

            // Update the show_on_footer field to 1
            $this->request = $this->request->withData('show_on_footer', 1);
            $banner = $this->Banners->patchEntity($banner, $this->request->getData());

            // Save the updated banner
            if ($this->Banners->save($banner)) {
                // Log successful save
                Log::debug('Banner set to show on footer successfully.', ['id' => $id]);
                // Set success flash message
                $this->Flash->success(__('Banner successfully set to show on footer.'));
            } else {
                // Log save error
                Log::error('Error setting banner to show on footer.', ['id' => $id, 'errors' => $banner->getErrors()]);
                // Set error flash message
                $this->Flash->error(__('Error occurred while setting the banner to show on the footer.'));
            }
        } catch (\Exception $e) {
            // Log exception
            Log::error('Exception setting banner to show on footer.', ['id' => $id, 'exception' => $e]);
            // Set error flash message
            $this->Flash->error(__('An error occurred while setting the banner to show on the footer. Please try again later.'));
        }

        // Redirect to the referring page
        return $this->redirect($this->referer());
    }


    public function listBanners()
    {
        // Initialize page variables
        $pageTitle = "Order";

        try {
            // Log the start of the list banners process
            Log::debug('Fetching list of banners.');

            // Fetch banners with status 1 and order by ID in descending order
            $listings = $this->Banners->find('all')
                ->where(['Banners.status' => 1])
                ->order(['Banners.id' => 'DESC']);

            // Paginate the results
            $listings = $this->paginate($listings);

            // Log successful fetch of banners
            Log::debug('List of banners fetched successfully.', ['count' => $listings->count()]);

        } catch (\Exception $e) {
            // Log any exception that occurs
            Log::error('Error fetching list of banners.', ['exception' => $e]);
            // Set an error flash message for the user
            $this->Flash->error(__('There was an error fetching the list of banners. Please try again later.'));
            // Set listings to an empty result set in case of error
            $listings = [];
        }

        // Set variables for the view
        $this->set(compact('pageTitle', 'listings'));
    }

    public function sectionTopIndex()
    {
        $pageTitle = '';
        $pageSubTitle = 'Section Top';
        $pageContentTitle = 'All Banners';
        $bannerQueryOptions = null;
        $orderQuery = null;

        $bannerSchema = $this->Banners->getSchema();
        // Get all columns from the menu schema
        $allColumns = $bannerSchema->columns();
        // Check if the 'section_id' column exists
        $sectionIdColumnExists = in_array('section_id', $allColumns);
        $orderValueColumnExists = in_array('order_value', $allColumns);

        $bannerQueryOptions = [
            'status' => 5
        ];

        if ($sectionIdColumnExists) {
            $bannerQueryOptions = [
                'conditions' => ['status' => 1, 'section_id' => 2]
            ];
        }

        if ($orderValueColumnExists) {
            $orderQuery = ['order_value' => 'Asc'];
        }

        $llistings = $this->Banners->find('all', $bannerQueryOptions)->order($orderQuery);
        $listings = $this->paginate($llistings);
        $this->set(compact('pageTitle', 'listings', 'pageSubTitle', 'pageContentTitle'));
    }

    public function sectionTopAdd()
    {
        $pageTitle = '';
        $pageSubTitle = 'Section Top';
        $pageContentTitle = 'Add Section Top Banners';
        $cmsbanners = $this->Banners->newEmptyEntity();

        if ($this->request->is(['post'])) {
            $data = $this->request->getData();
            $image_field = 'image1';
            $image_path = $this->request->getData($image_field);
            $imageSize = $image_path->getSize();

            // Check if there is an image and then update the image path
            if ($imageSize > 0) {
                $fileOK = $this->uploadFiles(Configure::read('IMAGE_PREPATH'), $data['image1']);

                if (!empty($fileOK['urls'])) {
                    $data['image_path'] = substr(
                        $fileOK['file_path'][0],
                        Configure::read('IMAGE_PRELENGTH'),
                        strlen($fileOK['file_path'][0])
                    );
                }
            } else {
                $data['image1'] = 'temp';
            }


            $bannerSchema = $this->Banners->getSchema();
            // Get all columns from the menu schema
            $allColumns = $bannerSchema->columns();
            // Check if the 'section_id' column exists
            $sectionIdColumnExists = in_array('section_id', $allColumns);
            $orderValueColumnExists = in_array('order_value', $allColumns);

            if ($sectionIdColumnExists) {
                $data['section_id'] = 2;
                // $data['status'] = 1;
            } else {
                // $data['status'] = 5;
            }

            $cmsbanners = $this->Banners->patchEntity($cmsbanners, $data);

            if ($this->Banners->save($cmsbanners)) {
                $this->Flash->success(__('Banners added successfully.'));
                return $this->redirect(['action' => 'sectionTopPending']);
            } else {
                $this->Flash->error(__('The row could not be save. Try again'));
            }
        }
        $this->set(compact('pageTitle', 'pageSubTitle', 'cmsbanners', 'pageContentTitle'));
    }

    public function sectionTopEdit($id)
    {
        $pageTitle = '';
        $pageSubTitle = 'Home ';
        $pageContentTitle = 'Edit Home Banners';
        $cmsbanners = $this->Banners->get($id);
        $sectionlist = $this->Menus->find('all')->where(['status' => 1]);

        if ($this->request->is(['post', 'put', 'patch'])) {
            $data = $this->request->getData();
            $image_field = 'image1';
            $image_path = $this->request->getData($image_field);
            $imageSize = $image_path->getSize();

            if (isset($data[$image_field])) {
                $fileOK = $this->uploadFiles(Configure::read('IMAGE_PREPATH'), $data[$image_field], null, null, false);
                if (!empty($fileOK['urls'])) {
                    $data['image_path'] = substr(
                        $fileOK['file_path'][0],
                        Configure::read('IMAGE_PRELENGTH'),
                        strlen($fileOK['file_path'][0])
                    );
                }
            } else {
                $data['image_path'] = 'temp';
            }

            $data['status'] = 2;
            $cmsbanners = $this->Banners->patchEntity($cmsbanners, $data);

            if ($this->Banners->save($cmsbanners)) {
                $this->Flash->success(__('banners added successfully.'));
                return $this->redirect(['action' => 'sectionTopEdited']);
            } else {
                $this->Flash->error(__('The row could not be save. Try again'));
            }
        }
        $this->set(compact('pageTitle', 'pageContentTitle', 'cmsbanners', 'sectionlist', 'pageSubTitle'));
    }

    // Section top pending
//this function shows all pending section top banners
    public function sectionTopPending()
    {
        $pageTitle = '';
        $pageSubTitle = 'Section Top';
        $pageContentTitle = 'Pending Banners';
        $orderQuery = null;
        $bannerQueryOptions = null;

        $bannerSchema = $this->Banners->getSchema();
        // Get all columns from the menu schema
        $allColumns = $bannerSchema->columns();
        // Check if the 'section_id' column exists
        $sectionIdColumnExists = in_array('section_id', $allColumns);
        $orderValueColumnExists = in_array('order_value', $allColumns);

        $bannerQueryOptions = [
            'conditions' => ['status' => 0]
        ];

        if ($sectionIdColumnExists) {
            $bannerQueryOptions['conditions']['Banners.section_id'] = 2;
        }

        if ($orderValueColumnExists) {
            $orderQuery = ['order_value' => 'Asc'];
        }

        $llistings = $this->Banners->find('all', $bannerQueryOptions)->order($orderQuery);

        $listings = $this->paginate($llistings);
        $this->set(compact('pageTitle', 'pageContentTitle', 'listings', 'pageSubTitle'));
    }

    // Section top enabled
//this function shows all enabled section top banners
    public function sectionTopEnabled()
    {
        $pageTitle = '';
        $pageSubTitle = 'Section Top';
        $pageContentTitle = 'Enabled Banners';
        $orderQuery = null;
        $bannerQueryOptions = null;

        $bannerSchema = $this->Banners->getSchema();
        // Get all columns from the menu schema
        $allColumns = $bannerSchema->columns();
        // Check if the 'section_id' column exists
        $sectionIdColumnExists = in_array('section_id', $allColumns);
        $orderValueColumnExists = in_array('order_value', $allColumns);

        $bannerQueryOptions = [
            'conditions' => ['status' => 5]
        ];

        if ($sectionIdColumnExists) {
            $bannerQueryOptions['conditions'] = [
                'Banners.section_id' => 2,
                'status' => 1,
            ];
        }

        if ($orderValueColumnExists) {
            $orderQuery = ['order_value' => 'Asc'];
        }

        $llistings = $this->Banners->find('all', $bannerQueryOptions)->order($orderQuery);


        $listings = $this->paginate($llistings);
        $this->set(compact('pageTitle', 'listings', 'pageSubTitle', 'pageContentTitle'));
    }

    // Section top disabled
//this function shows all disabled section top banners
    public function sectionTopDisabled()
    {
        $pageTitle = '';
        $pageSubTitle = 'Section Top';
        $pageContentTitle = 'Disabled Banners';
        $orderQuery = null;
        $bannerQueryOptions = null;

        $bannerSchema = $this->Banners->getSchema();
        // Get all columns from the menu schema
        $allColumns = $bannerSchema->columns();
        // Check if the 'section_id' column exists
        $sectionIdColumnExists = in_array('section_id', $allColumns);
        $orderValueColumnExists = in_array('order_value', $allColumns);

        $bannerQueryOptions = [
            'conditions' => ['status' => 99]
        ];

        if ($sectionIdColumnExists) {
            $bannerQueryOptions['conditions'] = [
                'Banners.section_id' => 2,
                'status' => 99,
            ];
        }

        if ($orderValueColumnExists) {
            $orderQuery = ['order_value' => 'Asc'];
        }

        $llistings = $this->Banners->find('all', $bannerQueryOptions)->order($orderQuery);

        $listings = $this->paginate($llistings);
        $this->set(compact('pageTitle', 'listings', 'pageSubTitle', 'pageContentTitle'));
    }

    // Section top edited
//this function shows all edited section top banners
    public function sectionTopEdited()
    {
        $pageTitle = '';
        $pageSubTitle = 'Section Top';
        $pageContentTitle = 'Edited Banners';
        $orderQuery = null;
        $bannerQueryOptions = null;

        $bannerSchema = $this->Banners->getSchema();
        // Get all columns from the menu schema
        $allColumns = $bannerSchema->columns();
        // Check if the 'section_id' column exists
        $sectionIdColumnExists = in_array('section_id', $allColumns);
        $orderValueColumnExists = in_array('order_value', $allColumns);

        $bannerQueryOptions = [
            'conditions' => ['status' => 2]
        ];

        if ($sectionIdColumnExists) {
            $bannerQueryOptions['conditions'] = [
                'Banners.section_id' => 2,
                'status' => 2,
            ];
        }

        if ($orderValueColumnExists) {
            $orderQuery = ['order_value' => 'Asc'];
        }

        $llistings = $this->Banners->find('all', $bannerQueryOptions)->order($orderQuery);

        $listings = $this->paginate($llistings);
        $this->set(compact('pageTitle', 'listings', 'pageSubTitle', 'pageContentTitle'));
    }

    public function sectionTopEnable($id = null)
    {
        // Disable layout for this action
        $this->viewBuilder()->disableAutoLayout();

        try {
            // Log the start of the enable process
            Log::debug('Enabling banner.', ['id' => $id]);

            // Fetch the banner by ID
            $banner = $this->Banners->get($id);


            $bannerSchema = $this->Banners->getSchema();
            // Get all columns from the menu schema
            $allColumns = $bannerSchema->columns();
            // Check if the 'section_id' column exists
            $sectionIdColumnExists = in_array('section_id', $allColumns);
            $orderValueColumnExists = in_array('order_value', $allColumns);

            if ($sectionIdColumnExists) {
                // Update the status to enabled
                $banner->status = 1;
            } else {
                // Update the status to enabled
                $banner->status = 5;
            }

            // Save the updated banner
            if ($this->Banners->save($banner)) {
                // Log successful save
                Log::debug('Banner enabled successfully.', ['id' => $id]);
                // Set success flash message
                $this->Flash->success(__('Banner enabled successfully.'));
            } else {
                // Log save error
                Log::error('Error enabling banner.', ['id' => $id, 'errors' => $banner->getErrors()]);
                // Set error flash message
                $this->Flash->error(__('Error occurred while enabling the banner.'));
            }
        } catch (\Exception $e) {
            // Log exception
            Log::error('Exception enabling banner.', ['id' => $id, 'exception' => $e]);
            // Set error flash message
            $this->Flash->error(__('An error occurred while enabling the banner. Please try again later.'));
        }

        // Redirect to the referring page
        return $this->redirect($this->referer());
    }

}