<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Content Entity
 *
 * @property int $id
 * @property string $name
 * @property string|null $slug
 * @property int|null $menu_id
 * @property string|null $content
 * @property string|null $caption
 * @property string|null $image_path
 * @property string $video_link
 * @property string|null $urls
 * @property string|null $file_path
 * @property int $status
 * @property string|null $level
 * @property int|null $show_on_home
 * @property string|null $fa_icon
 * @property int|null $order_value
 * @property string|null $info1
 * @property string|null $map_address
 * @property int $show_on_footer
 * @property \Cake\I18n\FrozenTime|null $created_date
 * @property \Cake\I18n\FrozenTime|null $modified_date
 * @property int|null $section_id
 * @property int|null $price
 * @property \Cake\I18n\FrozenTime|null $created
 * @property \Cake\I18n\FrozenTime|null $modified
 *
 * @property \App\Model\Entity\Menu $menu
 * @property \App\Model\Entity\ContentImage[] $content_images
 * @property \App\Model\Entity\PageContent[] $page_contents
 */
class Content extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'name' => true,
        'slug' => true,
        'menu_id' => true,
        'content' => true,
        'caption' => true,
        'image_path' => true,
        'video_link' => true,
        'urls' => true,
        'file_path' => true,
        'status' => true,
        'level' => true,
        'show_on_home' => true,
        'fa_icon' => true,
        'order_value' => true,
        'info1' => true,
        'map_address' => true,
        'show_on_footer' => true,
        'created_date' => true,
        'modified_date' => true,
        'section_id' => true,
        'price' => true,
        'created' => true,
        'modified' => true,
        'menu' => true,
        'content_images' => true,
        'page_contents' => true,
    ];
}
