<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Menu Entity
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $description
 * @property int $parent_menu_id
 * @property int $status
 * @property string|null $slug
 * @property int|null $show_on_home
 * @property int $show_on_footer
 * @property int|null $show_on_top
 * @property string|null $image_path
 * @property string|null $content
 * @property int $order_value
 * @property string $home_order
 * @property int|null $show_button
 * @property string|null $menu_link
 * @property \Cake\I18n\FrozenTime|null $created
 * @property \Cake\I18n\FrozenTime|null $modified
 *
 * @property \App\Model\Entity\Album[] $albums
 * @property \App\Model\Entity\Content[] $contents
 * @property \App\Model\Entity\PageContent[] $page_contents
 * @property \App\Model\Entity\PageProduct[] $page_products
 */
class Menu extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'name' => true,
        'description' => true,
        'parent_menu_id' => true,
        'status' => true,
        'slug' => true,
        'show_on_home' => true,
        'show_on_footer' => true,
        'show_on_top' => true,
        'image_path' => true,
        'content' => true,
        'order_value' => true,
        'home_order' => true,
        'show_button' => true,
        'menu_link' => true,
        'created' => true,
        'modified' => true,
        'albums' => true,
        'contents' => true,
        'page_contents' => true,
        'page_products' => true,
    ];
}
