<!-- Responsive Container -->
<div class="container my-4">
    <!-- Top Pagination Info -->
    <div class="text-center mb-3">
        <p class="mb-0">
            <?= $this->Paginator->counter(
                __('Page {{page}} of {{pages}}, showing {{current}} records out of {{count}} total')
            ) ?>
        </p>
    </div>
    
    <!-- Flash Messages -->
    <div class="text-center">
        <?= $this->Flash->render() ?>
    </div>

    <!-- Limit Control & Table -->
    <div class="row mb-3 align-items-center">
        <!-- Records Per Page Control -->
        <div class="col-sm-6">
            <div class="d-flex align-items-center">
                <label class="form-label me-2 mb-0">Records per page:</label>
                <?= $this->Paginator->limitControl([10 => 10, 20 => 20, 50 => 50, 100 => 100], null, ['class' => 'form-select', 'label'=>false]) ?>
            </div>
        </div>
    </div>

    <!-- Table Content -->
    <div class="table-responsive">
        <table class="table table-striped align-middle">
            <thead class="table-light">
                <tr>
                    <th>Name</th>
                    <th>Description</th>
                    <th>Image</th>
                    <th class="text-center">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($listings as $listing): ?>
                    <?php $img = Cake\Core\Configure::read('IMAGE_PREPATH') . $listing->image_path; ?>
                    <tr>
                        <td>
                            <?= $this->Html->link(__($listing->name), ['controller' => 'gallery', 'action' => 'details', $listing->id]) ?>
                        </td>
                        <td><?= $listing->description ?></td>
                        <td>
                            <?php if (isset($listing->image_path) && trim($listing->image_path) != ''): ?>
                                <a href="<?= $this->Url->image($img) ?>">
                                    <?= $this->Html->image($img, ['class' => 'img-fluid', 'alt' => $listing->name, 'style' => 'max-height: 70px;']) ?>
                                </a>
                            <?php endif; ?>
                        </td>
                        <td class="text-center">
                            <?php
                            if ($listing->status == 1) {
                                echo $this->Html->link(__('Disable'), ['controller' => 'gallery', 'action' => 'albums', 'disable', $listing->id], ['class' => 'btn btn-sm btn-outline-danger me-1']);
                            } else {
                                echo $this->Html->link(__('Enable'), ['controller' => 'gallery', 'action' => 'albums', 'enable', $listing->id], ['class' => 'btn btn-sm btn-outline-success me-1']);
                            }
                            echo $this->Html->link(__('Edit'), ['controller' => 'gallery', 'action' => 'albums', 'edit', $listing->id], ['class' => 'btn btn-sm btn-outline-primary']);
                            ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination Controls -->
    <div class="row">
        <div class="col-md-6">
            <p class="mb-0"><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of {{count}} total')) ?></p>
        </div>
        <div class="col-md-6">
            <nav aria-label="Page navigation" class="d-flex justify-content-end">
                <ul class="pagination pagination-sm mb-0">
                    <?= $this->Paginator->prev('< ' . __('prev'), ['class' => 'page-link']) ?>
                    <?= $this->Paginator->numbers(['first' => 1, 'last' => 1, 'modulus' => 2, 'class' => 'page-link']) ?>
                    <?= $this->Paginator->next(__('next') . ' >', ['class' => 'page-link']) ?>
                </ul>
            </nav>
        </div>
    </div>
</div>
