<?php
$formKey = rand(-10000000, -100000);
?>
<?= $this->Form->create($cmsbanners, ['enctype' => 'multipart/form-data', 'class' => 'form-horizontal row-fluid']) ?>
<div class="row form-area">
    
    <?= $this->Form->hidden('form_key', ['value' => $formKey]) ?>

    <p style="margin:0px 0px;">&nbsp;</p>
    <div class="container">


        <div class="row form-group mb-3">
            <div class="col-sm-2 col-xs-12 field-label">
                Title
            </div>
            <div class="col-sm-7 col-xs-12 text-input">
                <?= $this->Form->control('title', ['class' => 'form-control', 'label' => false]); ?>
            </div>
        </div>

        <div class="row form-group mb-3">
            <div class="col-sm-2 col-xs-12 field-label">
                Description
            </div>
            <div class="col-sm-7 col-xs-12 text-input">
                <?= $this->Form->control('description', ['class' => 'form-control', 'label' => false]); ?>
            </div>
        </div>

        <div class="row form-group mb-3">
            <div class="col-sm-2 col-xs-12 field-label">
                Banner Link
            </div>
            <div class="col-sm-7 col-xs-12 text-input">
                <?= $this->Form->control('url_link', ['class' => 'form-control', 'label' => false]); ?>
            </div>
        </div>

        <div class="row form-group mb-3">
            <div class="col-sm-2 col-xs-12 field-label">
                Section
            </div>
            <div class="col-sm-7 col-xs-12 text-input">
                <?= $this->Form->control('section', ['class' => 'form-control', 'value' => isset($sectionlist) ? '' : null, 'options' => '', 'label' => false, 'empty' => '-- Select --', 'id' => 'section-id']); ?>
            </div>
        </div>


        <div class="row form-group">
            <div class="col-sm-2 col-xs-12 field-label">
                Image
            </div>
            <div class="col-sm-7 col-xs-12 text-input mb-3">
                <?= $this->Form->control('image1', ['type' => 'file', 'class' => 'form-control', 'label' => false]); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-md-9 col-sm-6 d-flex justify-content-end align-items-end my-4">
                <?= $this->Form->button(__('Submit'), ['class' => 'btn btn-primary pull-right']) ?>
            </div>
        </div>

    </div>
</div>

<?= $this->Form->end() ?>

<script nonce="<?= $scriptNonce ?>">

    Dropzone.autoDiscover = false; // Disable automatic Dropzone discovery

    const csrfToken = "<?= $this->request->getAttribute('csrfToken') ?>"; // Get CSRF token

    // Initialize Dropzone on the specific element
    const myDropzone = new Dropzone("#image-upload", {
        url: '<?= $this->Url->build(['controller' => 'Banners', 'action' => 'addImage', $formKey]); ?>', // Replace with your upload action
        paramName: "file", // The name that will be used to transfer the file
        maxFilesize: 5, // MB
        acceptedFiles: ".jpeg,.jpg,.png,.gif",
        addRemoveLinks: true,
        dictDefaultMessage: "Drag files here or click to upload",

        // Include CSRF token in headers
        headers: {
            "X-CSRF-Token": csrfToken
        },

        init: function () {
            this.on("success", function (file, response) {
                console.log("File uploaded successfully:", response);
            });
            this.on("error", function (file, response) {
                console.log("File upload error:", response);
            });
        }
    });

</script>