<div class="container-fluid py-4">

    <div class="row align-items-center mb-4">
        <div class="col-12 col-md-4">
            <div class="d-flex align-items-center">
                <label for="limitControl" class="me-2">View per page:</label>
                <select id="limitControl" class="form-select form-select-sm w-25">
                    <option value="5">5</option>
                    <option value="10" selected>10</option>
                    <option value="20">20</option>
                    <option value="50">50</option>
                </select>
            </div>
        </div>
        <div class="col-12 col-md-4"></div>

        <div class="col-12 col-md-4 mt-3 mt-md-0">
            <div class="input-group">
                <input type="text" id="myInput" class="form-control w-25" placeholder="Search..." aria-label="Search">
                <!-- <button class="btn btn-outline-secondary" type="button"><i class="bi bi-search"></i></button> -->
            </div>
        </div>
    </div>

    <div class="table-responsive">
        <table class="table table-striped table-hover table-responsive-card">

            <thead>
                <tr>
                    <th>Banner</th>
                    <th>Title</th>
                    <th>Description </th>
                    <th>Actions</th>
                </tr>
            </thead>

            <tbody id="myTable">
                <?php foreach ($listings as $listing): ?>
                    <?php $image_path = Cake\Core\Configure::read('IMAGE_PREPATH') . $listing->image_path;
                    ?>
                    <tr>

                        <td data-label="Banner">

                            <?= isset($image_path)?'<a href="' . $this->Url->image($image_path) . '">' . $this->Html->image($image_path, ['height' => '80px', 'class' => 'border rounded', 'style' => 'max-width: 100px;']) . '</a>' : '<img src="/placeholder.svg?height=100&width=100" alt="" class="img-thumbnail" style="max-width: 100px;">' ?>
                        </td>

                        <td data-label="Title"><?= $listing->title ?></td>

                        <td data-label="Description">
                            <?= $listing->description ?>
                        </td>

                        <td data-label="Actions">
                            <div class="btn-group d-flexs justify-content-end align-content-end" role="group">
                                <?php
                                if (in_array($listing->status, [0, 2, 99])) { ?>
                                    <a
                                        href="<?= $this->Url->build(['action' => 'enable', $listing->id]); ?>">
                                        <button type="button" class="btn btn-sm btn-outline-primary" title="Enable"><i
                                                class="bi bi-power"></i>
                                        </button>
                                    </a>
                                <?php } else if ($listing->status == 1) { ?>
                                        <a
                                            href="<?= $this->Url->build(['action' => 'disable', $listing->id]) ?>">
                                            <button type="button" class="btn btn-sm btn-outline-info" title="Disable"><i
                                                    class="bi bi-power"></i>
                                            </button>
                                        </a>
                                <?php } ?>

                                <a
                                    href="<?= $this->Url->build(['action' => 'edit', $listing->id]) ?>">
                                    <button type="button" class="btn btn-sm btn-outline-secondary" title="Edit"><i
                                            class="bi bi-pencil"></i>
                                    </button>
                                </a>

                                                 </div>
                        </td>

                    </tr>
                <?php endforeach; ?>
            </tbody>

        </table>

    </div>
    <?php echo $this->element('pagination/pagination'); ?>

</div>

<script nonce="<?= $scriptNonce ?>">
    $(document).ready(function () {
        $("#myInput").on("keyup", function () {
            var value = $(this).val().toLowerCase();
            $("#myTable tr").filter(function () {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        });
    });
</script>