<div class="my-5 bg-white py-4">
    <div class="container">
        <div class="row g-4">
            <?php foreach ($listings as $listing): ?>
                <div class="col-12 col-sm-6 col-md-4 col-lg-3 mb-4">

                    <!-- Content Image -->
                    <div class="contain">
                        <?= $this->Html->image(Cake\Core\Configure::read('IMAGE_PREPATH', '') . $listing->image_path, [
                            'id' => 'image',
                            'class' => 'img-fluid h-75',
                            'alt' => h($listing->name) // Added alt attribute for accessibility
                        ]) ?>
                    </div>

                    <!-- Content Title -->
                    <div class="text-center text-area mt-2">
                        <h4 class='fw-bold'>
                            <?= $this->Text->truncate(h(strip_tags($listing->name)), 90, ['ellipsis' => '...', 'exact' => false]) ?>
                        </h4>
                    </div>

                    <!-- Content Buttons -->
                    <div class="text-center mt-3">
                        <?php
                        if (in_array($listing->status, [0, 2, 99])) {
                            echo $this->Html->link(__('Enable'), ['controller' => 'Gallery', 'action' => 'enable', $listing->id], ['class' => 'btn btn-info me-2']);
                        } else if ($listing->status == 1) {
                            echo $this->Html->link(__('Disable'), ['controller' => 'Gallery', 'action' => 'disable', $listing->id], ['class' => 'btn btn-primary me-2']);
                        }
                        echo $this->Html->link(__('Remove'), ['controller' => 'Gallery', 'action' => 'remove', $listing->id], ['class' => 'btn btn-danger']);
                        ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

        <!-- Pagination -->
        <div class="mt-4">
            <?php echo $this->element('pagination/pagination'); ?>
        </div>
    </div>
</div>