<div class="container-fluid py-4">

	<div class="row align-items-center mb-4">
		<div class="col-12 col-md-4">
			<div class="d-flex align-items-center">
				<label for="limitControl" class="me-2">View per page:</label>
				<select id="limitControl" class="form-select form-select-sm w-25">
					<option value="5">5</option>
					<option value="10" selected>10</option>
					<option value="20">20</option>
					<option value="50">50</option>
				</select>
			</div>
		</div>
		<div class="col-12 col-md-4"></div>

		<div class="col-12 col-md-4 mt-3 mt-md-0">
			<div class="input-group">
				<input type="text" id="myInput" class="form-control w-25" placeholder="Search..." aria-label="Search">
				<!-- <button class="btn btn-outline-secondary" type="button"><i class="bi bi-search"></i></button> -->
			</div>
		</div>
	</div>

	<div class="table-responsive">
		<table class="table table-striped table-hover table-responsive-card">

			<thead>
				<tr>
					<th>Section</th>
					<th>Name</th>
					<th>Content</th>
					<th>Status</th>
					<th>Home</th>
					<th>Image</th>
					<th>Actions</th>
				</tr>
			</thead>

			<tbody id="myTable">
				<?php foreach ($listings as $listing): ?>
					<?php $img = Cake\Core\Configure::read('IMAGE_PREPATH') . 'noimage.jpg';
					$showImage = false;
					if (!empty($listing->content->content_images) && !empty(trim($listing->content->content_images[0]->image_path))) {
						$img = Cake\Core\Configure::read('IMAGE_PREPATH') . $listing->content->content_images[0]->image_path;
					}

					if (file_exists(realpath($img)) && (filesize(realpath($img)) > 4000)) {
						$showImage = true;
					}
					?>
					<tr>

						<td data-label="Section"><?= $listing->menu->name ?></td>

						<td data-label="Name"><?= $listing->content->name ?></td>

						<td data-label="Content">
							<?= $this->Text->truncate(strip_tags($listing->content->content), 150, ['ellipsis' => '...', 'exact' => false]) ?>
						</td>

						<td data-label="Status"><?= $listing->content->status_name ?></td>

						<td data-label="Home"><?= $listing->content->show_on_home == 1 ? 'Yes' : 'No' ?></td>

						<td data-label="Image">
							total:
							<?= is_countable($listing->content->content_images) ? sizeof($listing->content->content_images) : 0 ?>
							<?= is_countable($listing->content->content_images) && sizeof($listing->content->content_images) > 0 ? '<br/>' : '' ?>
							<?= $showImage ? '<a href="' . $this->Url->image($img) . '">' . $this->Html->image($img, ['height' => '80px', 'class' => 'border rounded', 'style' => 'max-width: 100px;']) . '</a>' : '<img src="/placeholder.svg?height=100&width=100" alt="" class="img-thumbnail" style="max-width: 100px;">' ?>
						</td>

						<td data-label="Actions">
							<div class="btn-group d-flexs justify-content-end align-content-end" role="group">
								<?php
								if (in_array($listing->content->status, [0, 2, 99])) { ?>
									<a
										href="<?= $this->Url->build(['controller' => $this->request->getParam('section') ?? $this->request->getParam('controller'), 'action' => 'enableListing', $listing->content->id]); ?>">
										<button type="button" class="btn btn-sm btn-outline-primary" title="Enable"><i class="bi bi-power"></i>
										</button>
									</a>
								<?php } else if ($listing->content->status == 1) { ?>
										<a
											href="<?= $this->Url->build(['controller' => $this->request->getParam('section') ?? $this->request->getParam('controller'), 'action' => 'disableListing', $listing->content->id]) ?>">
											<button type="button" class="btn btn-sm btn-outline-info" title="Disable"><i class="bi bi-power"></i>
											</button>
										</a>
								<?php } ?>

								<a
									href="<?= $this->Url->build(['controller' => $this->request->getParam('section') ?? $this->request->getParam('controller'), 'action' => 'edit', $menuitemid, $listing->content->id, $listing->id]) ?>">
									<button type="button" class="btn btn-sm btn-outline-secondary" title="Edit"><i class="bi bi-pencil"></i>
									</button>
								</a>

								<?php if ($listing->content->show_on_home == 1) { ?>
									<a
										href="<?= $this->Url->build(['controller' => $this->request->getParam('section') ?? $this->request->getParam('controller'), 'action' => 'removeFromHome', $listing->content->id]) ?>">
										<button type="button" class="btn btn-sm btn-outline-danger" title="Remove from on Home"><i
												class="bi bi-house"></i>
										</button>
									</a>
								<?php } else { ?>
									<a
										href="<?= $this->Url->build(['controller' => $this->request->getParam('section') ?? $this->request->getParam('controller'), 'action' => 'showOnHome', $listing->content->id]) ?>">
										<button type="button" class="btn btn-sm btn-outline-success" title="Show on Home"><i
												class="bi bi-house"></i>
										</button>
									</a>
								<?php } ?>

								<!-- <button type="button" class="btn btn-sm btn-outline-danger" title="Remove from Home"><i
										class="bi bi-house"></i>
								</button> -->

							</div>
						</td>

					</tr>
				<?php endforeach; ?>
			</tbody>

		</table>

	</div>
	<?php echo $this->element('pagination/pagination'); ?>

</div>

<script nonce="<?= $scriptNonce ?>">
	$(document).ready(function () {
		$("#myInput").on("keyup", function () {
			var value = $(this).val().toLowerCase();
			$("#myTable tr").filter(function () {
				$(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
			});
		});
	});
</script>