<div class="row form-area">
    <div class="container">
        <?= $this->Form->create(null, [
            'url' => ['controller' => 'Settings', 'action' => 'updateSiteName'],
            'enctype' => 'multipart/form-data',
            'class' => 'form-horizontal row-fluid'
        ]) ?>

        <div class="mb-3 row">
            <label class="col-sm-2 col-form-label">Site Name</label>
            <div class="col-sm-8">
                <?= $this->Form->control('site_name', [
                    'class' => 'form-control',
                    'label' => false,
                    'required' => true,
                    'value' => $siteName
                ]) ?>
            </div>
        </div>

        <div class="mb-3 row">
            <label class="col-sm-2 col-form-label">Logo</label>
            <div class="col-sm-8">
                <?= $this->Form->control('image1', [
                    'type' => 'file',
                    'class' => 'form-control',
                    'label' => false
                ]) ?>
            </div>
        </div>

        <div class="mb-3 row">
            <label class="col-sm-2 col-form-label">Logo Image</label>
            <div class="col-sm-8">
                <?php if (!empty($siteLogo)): ?>
                    <?= $this->Html->image(Cake\Core\Configure::read('IMAGE_PREPATH') . $siteLogo, [
                        'height' => '100px',
                        'width' => '400px',
                        'class' => 'img-fluid'
                    ]) ?>
                <?php endif ?>
            </div>
        </div>

        <div class="row">
            <div class="col-md-10 col-sm-12 d-flex justify-content-end align-items-end my-4">
                <?= $this->Form->button(__('Update'), ['class' => 'btn btn-primary pull-right']) ?>
            </div>
        </div>

        <?= $this->Form->end() ?>
    </div>
</div>