<div class="container my-4">
    <!-- Search Field -->
    <div class="row align-items-center mb-4">
        <div class="col-12 col-md-4">
            <div class="d-flex align-items-center">
                <label for="limitControl" class="me-2">View per page:</label>
                <select id="limitControl" class="form-select form-select-sm w-25">
                    <option value="5">5</option>
                    <option value="10" selected>10</option>
                    <option value="20">20</option>
                    <option value="50">50</option>
                </select>
            </div>
        </div>
        <div class="col-12 col-md-4"></div>

        <div class="col-12 col-md-4 mt-3 mt-md-0">
            <div class="input-group">
                <input type="text" id="myInput" class="form-control w-25" placeholder="Search..." aria-label="Search">
                <!-- <button class="btn btn-outline-secondary" type="button"><i class="bi bi-search"></i></button> -->
            </div>
        </div>
    </div>

    <div class="table-responsive">
        <table class="table table-striped">
            <thead>
                <th>Name</th>
                <th>Descriptions</th>
                <th>Content</th>
                <th>Home</th>
                <th>Icon</th>
                <th>Image</th>
                <th>Actions</th>
            </thead>
            <tbody>
                <?php foreach ($listings as $listing) {
                    $img = Cake\Core\Configure::read('IMAGE_PREPATH') . $listing->image_path; ?>
                    <tr>
                        <td><?= $listing->name ?></td>
                        <td><?= $listing->description ?></td>
                        <td><?= $this->Text->truncate(strip_tags($listing->content), 200, ['ellipsis' => '...', 'exact' => false]) ?>
                        </td>
                        <td><?= $listing->show_on_home == 1 ? 'Yes' : 'No' ?></td>
                        <td><span><i class="fa <?= $listing->fa_icon ?>"></i></span> <?= $listing->fa_icon ?></td>

                        <td>
                            <?= isset($listing->image_path) && trim($listing->image_path) != '' ? '<a href="' . $this->Url->image($img) . '">' . $this->Html->image($img, ['height' => '70px']) . '</a>' : '' ?>
                        </td>

                        <td class="actions">
                            <?php
                            echo $this->Html->link(__('Edit '), ['controller' => $slug, 'action' => 'editMenu', $listing->id], ['class' => 'btn btn-sm btn-info', 'style' => 'margin-bottom: 5px;']);
                            echo '  ';
                            //  echo $this->Html->link(__('View'), ['controller'=>$slug,'action' =>'view' , $listing->id],['class' => 'btn btn-sm btn-default', 'style' => 'margin-bottom: 5px;']); 
                            echo "  ";
                            if ($listing->status == 1) {
                                echo $this->Html->link(__('Disable '), ['controller' => $slug, 'action' => 'disableMenu', $listing->id], ['class' => 'btn btn-sm btn-danger', 'style' => 'margin-bottom: 5px;']);
                            } else {
                                echo $this->Html->link(__('Enable '), ['controller' => $slug, 'action' => 'enableMenu', $listing->id], ['class' => 'btn btn-sm btn-success', 'style' => 'margin-bottom: 5px;']);
                            }

                            if ($listing->show_on_home == 1) {
                                echo "  " . $this->Html->link(__("Remove from home"), ['controller' => $slug, 'action' => 'removeMenuFromHome', $listing->id], ['class' => 'btn btn-sm btn-warning', 'style' => 'margin-bottom: 5px;']) . " ";
                            } else {
                                echo "  " . $this->Html->link(__("Show on home"), ['controller' => $slug, 'action' => 'showMenuOnHome', $listing->id], ['class' => 'btn btn-sm btn-primary', 'style' => 'margin-bottom: 5px;']) . " ";
                            }
                            ?>
                        </td>

                    </tr>

                <?php } ?>
            </tbody>
        </table>
    </div>
</div>
</div>

<?php echo $this->element('pagination/pagination'); ?>