<?php
/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link          https://cakephp.org CakePHP(tm) Project
 * @since         0.10.0
 * @license       https://opensource.org/licenses/mit-license.php MIT License
 * @var \App\View\AppView $this
 */

$cakeDescription = 'cms';
?>
<!DOCTYPE html>
<html>

<head>
    <?= $this->Html->charset() ?>

    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?= $this->Html->meta('csrfToken', $this->request->getAttribute('csrfToken')); ?>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-rbsA2VBKQhggwzxH7pPCaAqO46MgnOM80zW1RWuH61DGLwZJEdK2Kadq2F9CUG65" crossorigin="anonymous"
        nonce="<?= $styleNonce ?>">

    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet"
        nonce="<?= $styleNonce ?>">

    <link href="https://cdn.jsdelivr.net/npm/summernote@0.9.0/dist/summernote-bs5.min.css" rel="stylesheet"
        nonce="<?= $styleNonce ?>">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.3/min/dropzone.min.css"
        nonce="<?= $styleNonce ?>" />

    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css" rel="stylesheet"
        nonce="<?= $styleNonce ?>" />

        <link rel="stylesheet" href="https://cdn.ckeditor.com/ckeditor5/43.3.0/ckeditor5.css" nonce="<?= $styleNonce ?>"/>


    <title>
        <?= $cakeDescription ?>:
        <?= $this->fetch('title') ?>
    </title>

    <?= $this->Html->meta('icon') ?>

    <?= $this->Html->css(['simple-sidebar', 'style', 'custom_radio', 'jquery-ui.min', 'main_menu', 'table']) ?>

    <?= $this->Html->script(['jquery.min']) ?>

    <!-- </?= $this->Html->script('ckeditor/ckeditor5/ckeditor5.js') ?> -->

    <!-- <script type="module" src="</?php echo $this->Url->build('./ckeditor/ckeditor5/ckeditor5.js'); ?> "
        nonce="</?= $scriptNonce ?>"></script> -->
        

    <script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.3/min/dropzone.min.js"
        nonce="<?= $scriptNonce ?>"></script>

    <!-- <script src="https://cdn.jsdelivr.net/npm/summernote@0.9.0/dist/summernote-bs5.min.js"
        nonce="<?= $scriptNonce ?>"></script> -->

    <?= $this->fetch('meta') ?>
    <?= $this->fetch('css') ?>
    <?= $this->fetch('script') ?>
</head>

<body>

    <div class="top-bar">
        <?php echo $this->element('top_bar'); ?>
    </div>

    <div id="wrapper">
        <!-- Page Content -->
        <div id="page-content-wrapper">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-12">

                        <div class="text-center">
                            <?= $this->Flash->render() ?>
                        </div>

                        <div class="submenu">
                            <?php echo $this->element('menus/main_menu'); ?>
                        </div>

                        <div class="text-center">
                            <h4><b><?php // isset($title) ? $title : '' ?></b></h4>
                        </div>

                        <?= $this->fetch('content') ?>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <footer id="footer">
        <?php echo $this->element('footer'); ?>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-kenU1KFdBIe4zVF0s0G1M5b4hcpxyD9F7jL+jjXkk+Q2h455rYXK/7HAuoJl+0I4" crossorigin="anonymous"
        nonce="<?= $scriptNonce ?>"></script>

</body>

</html>